% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lorenz-curve.R
\name{Lorenz.curve}
\alias{Lorenz.curve}
\title{Concentration curve of \emph{y} with respect to \emph{x}}
\usage{
Lorenz.curve(
  y,
  x = y,
  graph = FALSE,
  na.rm = TRUE,
  ties.method = c("mean", "random"),
  seed = NULL,
  weights = NULL
)
}
\arguments{
\item{y}{variable of interest.}

\item{x}{variable to use for the ranking. By default \eqn{x=y}, and the obtained concentration curve is the Lorenz curve of \emph{y}.}

\item{graph}{whether a graph of the obtained concentration curve should be traced. Default value is FALSE.}

\item{na.rm}{should missing values be deleted. Default value is \code{TRUE}. If \code{FALSE} is selected, missing values generate an error message}

\item{ties.method}{What method should be used to break the ties in the rank index. Possible values are "mean" (default value) or "random". If "random" is selected, the ties are broken by further ranking in terms of a uniformly distributed random variable. If "mean" is selected, the average rank method is used.}

\item{seed}{seed imposed for the generation of the vector of uniform random variables used to break the ties. Default is NULL, in which case no seed is imposed.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}
}
\value{
A function corresponding to the estimated Lorenz or concentration curve. If \code{graph} is TRUE, the curve is also plotted.
}
\description{
\code{Lorenz.curve} computes the concentration curve index of a vector \emph{y} with respect to another vector \emph{x}.
If \emph{y} and \emph{x} are identical, the obtained concentration curve boils down to the Lorenz curve.
}
\details{
The parameter \code{seed} allows for local seed setting to control randomness in the generation of the uniform random variables.
The specified seed is applied to the respective part of the computation, and the seed is reverted to its previous state after the operation.
This ensures that the seed settings do not interfere with the global random state or other parts of the code.
}
\examples{
data(Data.Incomes)
# We first compute the Lorenz curve of Income
Y <- Data.Incomes$Income
Lorenz.curve(y = Y, graph = TRUE)
# Then we compute the concentration curve of Income with respect to Age
X <- Data.Incomes$Age
Lorenz.curve(y = Y, x = X, graph = TRUE)

}
\seealso{
\code{\link{Lorenz.graphs}}, \code{\link{Gini.coef}}
}
