% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_report.R
\name{t_test_report}
\alias{t_test_report}
\title{Print Student's t-Test report}
\usage{
t_test_report(
  data,
  treatment_col,
  value_col,
  paired,
  subject_col,
  report = TRUE
)
}
\arguments{
\item{data}{Data frame containing the treatment, value and other information.}

\item{treatment_col}{Numeric indicating where treatment locates (column number) in data.}

\item{value_col}{Numeric indicating where treatment value (column number) in data.}

\item{paired}{Logical indicating whether you want a paired t-test.}

\item{subject_col}{Only meaningful when Pair is ture. Numeric indicating where subject of treatment (column number) in data.}

\item{report}{Logical. If print report to console. Default:TRUE}
}
\value{
t_test_report returns list containing:
\enumerate{
\item data frame of basic data descrption
\item results of student's t-Test
}
}
\description{
Print Student's t-Test report
}
\examples{
{
  ### Data preparation ###
  testdata <- data.frame(
    treatment = c(rep("A", 6), rep("B", 6)),
    subject = rep(c(1:6), 2),
    value = c(rnorm(6, 2), rnorm(6, 1))
  )

  # Perform t-test (unpaired)
  t_test_result <- t_test_report(
    data = testdata,
    treatment_col = 1,
    value_col = 3
  )

  # Perform paired t-test
  t_test_result <- t_test_report(
    data = testdata,
    treatment_col = 1,
    value_col = 3,
    paired = TRUE,
    subject_col = 2
  )

  ### Basic data description ###
  print(t_test_result[[1]])
  print(t_test_result$basicdata)

  ### T-test results ###
  print(t_test_result[[2]])
  print(t_test_result$t.test_results)
}
}
