% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan.R
\name{manhattan}
\alias{manhattan}
\title{Manhattan Plot Generator}
\usage{
manhattan(
  inputframe,
  taxlevel = "Phylum",
  control_name,
  mode = "all",
  top_n = NULL,
  palette = "Set1",
  select_tax = NULL,
  rmprefix = NULL
)
}
\arguments{
\item{inputframe}{A data frame generated from \code{\link{Deseq_analysis}} or \code{\link{indicator_analysis}}}

\item{taxlevel}{Taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").Default:NULL.}

\item{control_name}{Character. The name of the control group for the comparison.}

\item{mode}{The mode for selecting which taxa to plot: "all" for all taxa, "most" for the top N taxa, and "select" for specific taxa selection}

\item{top_n}{The number of top taxa to plot when mode is set to "most"}

\item{palette}{Character. Palette for visualization,default:"Set1".Optional palette same as 'RColorBrewer'. "Plan1" to "Plan10" were also optional,see in \code{\link{color_scheme}}}

\item{select_tax}{A vector of taxa to be selected for plotting when mode is "select".}

\item{rmprefix}{A string prefix to be removed from the taxonomic annotation.Default:NULL.}
}
\value{
a list containing the Manhattan plot, circular Manhattan plot, source data, and color assignments
}
\description{
Generate Manhattan Plot  base on Deseq_analysis or indicator_analysis results
}
\examples{
\donttest{
{
  # Data preparation
  data("Two_group")

  # DESeq analysis
  deseq_results <- Deseq_analysis(
    taxobj = Two_group,
    taxlevel = "Base",
    cutoff = 1,
    control_name = "Control"
  )

  # Indicator analysis
  indicator_results <- indicator_analysis(
    taxobj = Two_group,
    taxlevel = "Genus"
  )

  # Show all with Manhattan plot
    manhattan_object <- manhattan(
      inputframe = deseq_results,
      taxlevel = "Phylum",
      control_name = "Control"
    )
    print(manhattan_object$manhattan)  # Tradition Manhattan plot
    print(manhattan_object$manhattan_circle)  # Circular Manhattan plot
    print(manhattan_object$sourcedata)  # Source data for plot
    print(manhattan_object$aes_color)  # Aesthetic color for plot

  # Top 8 Phyla with most taxon
    manhattan_object <- manhattan(
      inputframe = indicator_results,
      taxlevel = "Phylum",
      control_name = "Control",
      mode = "most",
      top_n = 8,
      palette = "Set1"
    )
    print(manhattan_object$manhattan)

  # Specific phyla
  # Top nine dominant phyla
    community <- community_plot(
      taxobj = Two_group,
      taxlevel = "Phylum",
      n = 9,
      palette = "Paired",
      rmprefix = "p__"
    )

    manhattan_object <- manhattan(
      inputframe = indicator_results,
      taxlevel = "Phylum",
      control_name = "Control",
      mode = "select",
      palette = community$filled_color,
      select_tax = names(community$filled_color),
      rmprefix = "p__"
    )
    print(manhattan_object$manhattan)
    print(manhattan_object$manhattan_circle)
}
}
}
