% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{UPSLTDdist}
\alias{UPSLTDdist}
\title{Plot the LTD distribution as a function of the number of clusters.}
\usage{
UPSLTDdist(envir, legloc = "bottomleft", ...)
}
\arguments{
\item{envir}{A LocalControlClassic environment containing UPSnnltd objects.}

\item{legloc}{Where to place the legend in the returned plot. Defaults to "bottomleft".}

\item{...}{
  Arguments passed on to \code{\link[graphics:plot.default]{graphics::plot}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
Returns the LTD distribution plot.

Adds the "ltdds" object to envir.
}
\description{
This function creates a plot displaying the distribution of
 Local Treatment Differences (LTDs) as a function of the number of clusters
 created for all UPSnnltd objects in the provided environment. The hinges and
 whiskers are generated using \code{\link[grDevices]{boxplot.stats}}.
}
\examples{

 data(lindner)
 cvars <- c("stent","height","female","diabetic","acutemi",
            "ejecfrac","ves1proc")
 numClusters <- c(1, 2, 10, 15, 20, 25, 30, 35, 40, 45, 50)
 results <- LocalControlClassic(data = lindner,
                                clusterVars = cvars,
                                treatmentColName = "abcix",
                                outcomeColName = "cardbill",
                                clusterCounts = numClusters)
 UPSLTDdist(results,ylim=c(-15000,15000))

}
