% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{svm_cv}
\alias{svm_cv}
\title{\emph{k}-fold Cross Validation for SVM}
\usage{
svm_cv(dataset, label.col = 1, positive.class = NULL, folds.num = 10,
  seed = 1, parallel.cores = 2, ...)
}
\arguments{
\item{dataset}{The dataset obtained from function \code{\link{extract_features}}.
Or datasets used to build the classifier.}

\item{label.col}{integer specifying the column number of the label. (Default: \code{1})}

\item{positive.class}{Character. Indicate the positive class of the dataset.
(Default: \code{NonCoding}) The value of this parameter should be identical to
one of the classes of the response vectors.}

\item{folds.num}{Integer. Specify the number of folds for cross-validation.
(Default: \code{10})}

\item{seed}{Integer. Used to set the seed for cross-validation. (Default: \code{1})}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}, users can set as \code{-1} to run
this function with all cores. If the number of \code{parallel.cores} is more
than the \code{folds.num} (number of the folds for cross-validation), the
number of \code{parallel.cores} will be set as \code{folds.num} automatically.}

\item{...}{additional parameters for function \code{\link[e1071]{svm}}.}
}
\value{
Returns the optimal parameters when \code{return.model = FALSE}.
Or returns the best model when \code{return.model = TRUE}.
}
\description{
This function conduct \emph{k}-fold Cross Validation for SVM.
}
\details{
During the model tuning, the performance of each combination of
parameters will output. Sensitivity, Specificity, Accuracy, F-Measure and Kappa
Value are used to evaluate the performances. The best gamma and cost (or best
model) are selected based on Accuracy.

For the details of parameter gamma and cost, please refer to function
\code{\link[e1071]{svm}} of package "e1071".

For the details of metrics, please refer to function
\code{\link[caret]{confusionMatrix}} of package "caret".
}
\examples{
\dontrun{
data(demo_dataset)
my_dataset <- demo_dataset

cv_res <- svm_cv(my_dataset, folds.num = 4, seed = 1,
                 parallel.core = 2, cost = 3, kernel = "radial", gamma = 0.5)

### Users can set return.model = TRUE to return the best model.
}
}
\seealso{
\code{\link{extract_features}}, \code{\link{svm_tune}}.
}
\author{
HAN Siyu
}
