% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idFunctionsNeg.R
\name{idBAneg}
\alias{idBAneg}
\title{Bile Acids (BA) annotation for ESI-}
\usage{
idBAneg(
  msobject,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 3,
  rt,
  adducts = c("M-H"),
  conjfrag = c("baconj_M-H"),
  bafrag = c("ba_M-H-H2O", "ba_M-H-2H2O"),
  coelCutoff = 0.8,
  dbs
)
}
\arguments{
\item{msobject}{an msobject returned by \link{dataProcessing}.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for BA in ESI-. Adducts allowed can
be modified in the adducsTable (dbs argument).}

\item{conjfrag}{character vector containing the fragmentation rules for
the BA-conjugates. By default just taurine and glycine are considered,
but baconjdb can be modified to add more possible conjugates.
See \link{chainFrags} for details. It can also be an empty vector.}

\item{bafrag}{character vector containing the fragmentation rules for
other BA fragments. See \link{chainFrags} for details. It can be an empty
vector.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
annotated msobject (list with several elements). The results element
is a data frame that shows: ID, class of lipid, CDB (total number of carbons
and double bounds), FA composition (specific chains composition if it has
been confirmed), m.z, RT (in seconds), I (intensity), Adducts, ppm (m.z error),
confidenceLevel (Subclass, FA level, where chains are known but not their
positions, or FA position level), peakID, and PFCS (parent-fragment coelution
score mean of all fragments used for the identification); and the
annotatedPeaklist element shows the original MS1 peaklist with the annotations
on it.
}
\description{
BA identification based on fragmentation patterns for LC-MS/MS DIA or DDA
data acquired in negative mode.
}
\details{
\code{idBAneg} function involves 3 steps. 1) FullMS-based
identification of candidate BA as M-H. 2) Search of BA-conjugate fragments if
required. 3) Search of fragments coming from the loss of H2O.

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (MS-only
if no rules are defined, or Subclass level if they are supported by fragments)
and PFCS (parent-fragment coelution score mean of all fragments used for the
identification).
}
\note{
This function has been writen based on fragmentation patterns
observed for three different platforms (QTOF 6550 from Agilent, Sinapt G2-Si
from Waters and Q-exactive from Thermo), but it may need to be customized for
other platforms or acquisition settings.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
msobject <- idBAneg(LipidMSdata2::msobjectDIAneg)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
