\name{LindleyR-package}
\alias{LindleyR-package}
\docType{package}
\title{
Overview of the LindleyR package
}
\description{The \pkg{LindleyR} package computes the probability density, the cumulative distribution, the quantile and   the hazard rate functions and generates random deviates from the discrete and continuous
Lindley distribution as well as for 19 of its modifications. It also generates censored random
deviates from any probability  distribution available in R. The Lindley, uniform and exponential
distributions can be used as the censoring distributions.}
\details{

\code{\link[LindleyR]{DLindley}:} implements the [d-p-q-r]dlindley functions for the one-parameter discrete Lindley distribution.

\code{\link[LindleyR]{DPLindley}:} implements the [d-p-q-r]dplindley functions for the discrete power Lindley distribution.

\code{\link[LindleyR]{DWLindley}:} implements the [d-p-q-r]dwlindley functions for the weighted discrete Lindley distribution.

\code{\link[LindleyR]{EXPLindley}:} implements the [d-h-p-q-r]explindley functions for the exponentiated Lindley distribution.

\code{\link[LindleyR]{EXPPLindley}:} implements the [d-h-p-q-r]expplindley functions for the exponentiated power Lindley distribution.

\code{\link[LindleyR]{EXTILindley}:} implements the [d-h-p-q-r]extilindley functions for the extended inverse Lindley distribution.

\code{\link[LindleyR]{EXTLindley}:} implements the [d-h-p-q-r]extlindley functions for the extended Lindley distribution.

\code{\link[LindleyR]{EXTPLindley}:} implements the [d-h-p-q-r]extplindley functions for the extended power Lindley distribution.

\code{\link[LindleyR]{GAMLindley}:} implements the [d-h-p-q-r]extplindley functions for the Gamma Lindley Lindley distribution.

\code{\link[LindleyR]{GENILindley}:} implements the [d-h-p-q-r]genilindley functions for the generalized inverse Lindley distribution.

\code{\link[LindleyR]{GENLindley}:} implements the [d-h-p-q-r]genlindley functions for the generalized Lindley distribution.

\code{\link[LindleyR]{ILindley}:} implements the [d-h-p-q-r]ilindley functions for the inverse Lindley distribution.

\code{\link[LindleyR]{Lindley}:} implements the [d-h-p-q-r]lindley functions for one-parameter Lindley distributio.

\code{\link[LindleyR]{LindleyE}:} implements the [d-h-p-q-r]lindleye functions for parameter Lindley exponential distribution.

\code{\link[LindleyR]{MOLindley}:} implements the [d-h-p-q-r]molindley functions for the Marshall-Olkin extended Lindley distribution.

\code{\link[LindleyR]{NWLindley}:} implements the [d-h-p-q-r]nwlindley functions for the new weighted Lindley distribution.

\code{\link[LindleyR]{PLindley}:} implements the [d-h-p-q-r]plindley functions for the power Lindley distribution.

\code{\link[LindleyR]{QLindley}:} implements the [d-h-p-q-r]qlindley functions for the quasi Lindley distribution.

\code{\link[LindleyR]{randcensor}:} generate censored random samples, with a desired censoring rate, from any continuous lifetime distribution supported by R.

\code{\link[LindleyR]{SLindley}:} implements the [d-h-p-q-r]slindley functions for the two-parameter Lindley distribution.

\code{\link[LindleyR]{TLindley}:} implements the [d-h-p-q-r]tlindley functions for the transmuted Lindley distribution.

\code{\link[LindleyR]{WLindley}:} implements the [d-h-p-q-r]wlindley functions for the weighted Lindley distribution.
}

\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}

Ricardo P. de Oliveira \email{rpuziol.oliveira@gmail.com}
}


