% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyE.R
\name{LindleyE}
\alias{LindleyE}
\alias{dlindleye}
\alias{hlindleye}
\alias{plindleye}
\alias{qlindleye}
\alias{rlindleye}
\title{Lindley Exponential Distribution}
\source{
[d-h-p-q-r]lindleye are calculated directly from the definitions. \code{rlindleye} uses the quantile function.
}
\usage{
dlindleye(x, theta, alpha, log = FALSE)

plindleye(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qlindleye(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rlindleye(n, theta, alpha)

hlindleye(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dlindleye} gives the density, \code{plindleye} gives the distribution function, \code{qlindleye} gives the quantile function, \code{rlindleye} generates random deviates and \code{hlindleye} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the Lindley exponential distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta ,\alpha )={\frac{{\theta }^{2}\alpha {{e}^{-\alpha x}}\left(1-{{e}^{-\alpha x}}\right) ^{\theta -1}\left[ 1-\log \left( 1-{{e}^{-\alpha x}}\right) \right] }{1+\theta }}}

Cumulative distribution function
\deqn{F(x\mid \theta ,\alpha )={\frac{\left( 1-{{e}^{-\alpha x}}\right) ^{\theta }\left[ 1+\theta -\theta \log \left( 1-{{e}^{-\alpha x}}\right) \right] }{1+\theta }}}

Quantile function
\deqn{\code{see Bhati et al., 2015}}

Hazard rate function
\deqn{\code{see Bhati et al., 2015}}
}
\examples{
set.seed(1)
x <- rlindleye(n = 1000, theta = 5.0, alpha = 0.2)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dlindleye(S, theta = 5.0, alpha = 0.2), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
plindleye(q, theta = 5.0, alpha = 0.2, lower.tail = TRUE)
plindleye(q, theta = 5.0, alpha = 0.2, lower.tail = FALSE)
qlindleye(p, theta = 5.0, alpha = 0.2, lower.tail = TRUE)
qlindleye(p, theta = 5.0, alpha = 0.2, lower.tail = FALSE)

## waiting times data (from Ghitany et al., 2008)
data(waitingtimes)
library(fitdistrplus)
fit <- fitdist(waitingtimes, 'lindleye', start = list(theta = 2.6, alpha = 0.15),
 lower = c(0.01, 0.01))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Bhati, D., Malik, M. A., Vaman, H. J., (2015). Lindley-Exponential distribution: properties and applications. \emph{METRON}, \bold{73}, (3), 335–357.
}
\seealso{
\code{\link[lamW]{lambertWm1}}.
}

