% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_W_delta.R, R/deriv_W_delta.R
\name{W_delta}
\alias{W_2delta}
\alias{W_2delta_2alpha}
\alias{W_delta}
\alias{W_delta_alpha}
\alias{deriv_W_delta}
\alias{deriv_W_delta_alpha}
\title{Inverse transformation for heavy-tail Lambert W RVs}
\usage{
W_delta(z, delta = 0)

W_delta_alpha(z, delta = 0, alpha = 1)

W_2delta(z, delta = c(0, 1/5))

W_2delta_2alpha(z, delta = c(0, 0), alpha = c(1, 1))

deriv_W_delta(z, delta = 0)

deriv_W_delta_alpha(z, delta = 1, alpha = 1)
}
\arguments{
\item{z}{a numeric vector of real values.}

\item{delta}{heavy-tail parameter(s); by default \code{delta = 0}, which
implies \code{W_delta(z) = z}. If a vector of length 2 is supplied, then
\code{delta[1]} on the left and \code{delta[2]} on the right (of the
center) will be used.}

\item{alpha}{heavy-tail exponent(s) in \eqn{(u^2)^{\alpha}}; default: \code{alpha = 1}.}
}
\value{
Computes sgn\eqn{(z) \left(\frac{1}{\alpha \delta} W(\alpha \delta (z^2)^{\alpha})
\right)^{1/2 \alpha}}. If \eqn{z} is a vector, so is the output.
}
\description{
Inverse transformation \code{W_delta_alpha} for heavy-tail Lambert W RVs and its derivative.
This is the inverse of Tukey's h transformation as a special case of \code{alpha = 1}.
}
\examples{

G_delta(0)
W_delta(0)

# W_delta is the inverse of G_delta
u.v <- -2:2
W_delta(G_delta(u.v, delta = 0.3), delta = 0.3)

# with alpha too
G_delta_alpha(u.v, delta = 1, alpha = 0.33)
W_delta_alpha(G_delta_alpha(u.v, delta = 1, alpha = 0.33), 
              delta = 1, alpha = 0.33) # the inverse

}
\keyword{math}

