% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_lucid.R
\name{predict_lucid}
\alias{predict_lucid}
\title{Predict cluster assignment and outcome based on LUCID model}
\usage{
predict_lucid(model, G, Z, Y = NULL, CoG = NULL, CoY = NULL, response = TRUE)
}
\arguments{
\item{model}{A model fitted and returned by \code{\link{est.lucid}}}

\item{G}{Exposures, a numeric vector, matrix, or data frame. Categorical variable 
should be transformed into dummy variables. If a matrix or data frame, rows 
represent observations and columns correspond to variables.}

\item{Z}{Omics data, a numeric matrix or data frame. Rows correspond to observations
and columns correspond to variables.}

\item{Y}{Outcome, a numeric vector. Categorical variable is not allowed. Binary 
outcome should be coded as 0 and 1.}

\item{CoG}{Optional, covariates to be adjusted for estimating the latent cluster.
A numeric vector, matrix or data frame. Categorical variable should be transformed 
into dummy variables.}

\item{CoY}{Optional, covariates to be adjusted for estimating the association 
between latent cluster and the outcome. A numeric vector, matrix or data frame. 
Categorical variable should be transformed into dummy variables.}

\item{response}{If TRUE, when predicting binary outcome, the response will be
returned. If FALSE, the linear predictor is returned.}
}
\value{
A list contains predicted latent cluster and outcome for each observation
}
\description{
Predict cluster assignment and outcome based on LUCID model
}
\examples{
\dontrun{
# prepare data
G <- sim_data$G
Z <- sim_data$Z
Y_normal <- sim_data$Y_normal

# fit lucid model
fit1 <- est.lucid(G = G, Z = Z, Y = Y_normal, K = 2, family = "normal")

# prediction on training set
pred1 <- predict_lucid(model = fit1, G = G, Z = Z, Y = Y_normal)
pred2 <- predict_lucid(model = fit1, G = G, Z = Z)
}
}
