% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_lucid.R
\name{pred_lucid}
\alias{pred_lucid}
\title{Model Predictions for LUCID}
\usage{
pred_lucid(Fit = NULL, G = NULL, CoG = NULL, Z = NULL, Y = NULL, CoY = NULL)
}
\arguments{
\item{Fit}{An \code{IntClust} class object}

\item{G}{Genetic effects, a matrix}

\item{CoG}{Covariates to be included in the G->X path}

\item{Z}{Biomarker data, a matrix}

\item{Y}{Disease outcome, a vector; default is NULL}

\item{CoY}{Covariates to be included in the X->Y path}
}
\value{
\code{pred_lucid} returns a list containing predicted values.
\item{pred_cluster}{predicted probabilities for latent clusters with/without the outcome}
\item{pred_outcome}{predicted values for outcome}
}
\description{
\code{pred_lucid} produces predicted values for latent clusters and outcome with an \code{IntClust} object and new data.
}
\examples{
set.seed(10)
IntClusFit <- est_lucid(G=G1,Z=Z1,Y=Y1,K=2,family="binary",Pred=TRUE)
GPred <- G2[1:20,]; ZPred <- Z2[1:20,]
PRED <- pred_lucid(Fit = IntClusFit, G=GPred, CoG = NULL, Z=ZPred, CoY = NULL)
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
