% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_matrix_functions.R
\name{construct_covmat_single}
\alias{construct_covmat_single}
\title{Constructing a covariance matrix for a single phenotype}
\usage{
construct_covmat_single(
  fam_vec = c("m", "f", "s1", "mgm", "mgf", "pgm", "pgf"),
  n_fam = NULL,
  add_ind = TRUE,
  h2 = 0.5
)
}
\arguments{
\item{fam_vec}{A vector of strings holding the different
family members. All family members must be represented by strings from the
following list:
\itemize{
\item \code{m} (Mother)
\item \code{f} (Father)
\item \code{c[0-9]*.[0-9]*} (Children)
\item \code{mgm} (Maternal grandmother)
\item \code{mgf} (Maternal grandfather)
\item \code{pgm} (Paternal grandmother)
\item \code{pgf} (Paternal grandfather)
\item \code{s[0-9]*} (Full siblings)
\item \code{mhs[0-9]*} (Half-siblings - maternal side)
\item \code{phs[0-9]*} (Half-siblings - paternal side)
\item \code{mau[0-9]*} (Aunts/Uncles - maternal side)
\item \code{pau[0-9]*} (Aunts/Uncles - paternal side).
}}

\item{n_fam}{A named vector holding the desired number of family members.
See \code{\link[stats]{setNames}}.
All names must be picked from the list mentioned above. Defaults to NULL.}

\item{add_ind}{A logical scalar indicating whether the genetic
component of the full liability as well as the full
liability for the underlying individual should be included in
the covariance matrix. Defaults to TRUE.}

\item{h2}{A number representing the squared heritability on liability scale
for a single phenotype. Must be non-negative and at most 1.
Defaults to 0.5.}
}
\value{
If either \code{fam_vec} or \code{n_fam} is used as the argument, if it
is of the required format and \code{h2} is a number satisfying
\eqn{0 \leq h2 \leq 1}, then the output will be a named covariance matrix.
The number of rows and columns corresponds to the length of \code{fam_vec}
or \code{n_fam} (+ 2 if \code{add_ind=TRUE}).
If both \code{fam_vec = c()/NULL} and \code{n_fam = c()/NULL}, the
function returns a \eqn{2 \times 2} matrix holding only the correlation
between the genetic component of the full liability and
the full liability for the individual. If both \code{fam_vec} and
\code{n_fam} are given, the user is asked to decide on which
of the two vectors to use.
Note that the returned object has different attributes, such as
\code{fam_vec}, \code{n_fam}, \code{add_ind} and \code{h2}.
}
\description{
\code{construct_covmatc_single} returns the covariance matrix for an
underlying target individual and a variable number of its family members
}
\details{
This function can be used to construct a covariance matrix for
a given number of family members. Each entry in this covariance
matrix equals the percentage of shared DNA between the corresponding
individuals times the liability-scale heritability \eqn{h^2}. The family members
can be specified using one of two possible formats.
}
\examples{
construct_covmat_single()
construct_covmat_single(fam_vec = c("m","mgm","mgf","mhs1","mhs2","mau1"), 
n_fam = NULL, add_ind = TRUE, h2 = 0.5)
construct_covmat_single(fam_vec = NULL, n_fam = stats::setNames(c(1,1,1,2,2), 
c("m","mgm","mgf","s","mhs")), add_ind = FALSE, h2 = 0.3)

}
\seealso{
\code{\link{get_relatedness}}, \code{\link{construct_covmat_multi}},
\code{\link{construct_covmat}}
}
