% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST.R
\name{E_Sobrino}
\alias{E_Sobrino}
\title{Land Surface Emissivity according to Sobrino et al. 2008}
\usage{
E_Sobrino(red = red, NDVI = NDVI)
}
\arguments{
\item{red}{Raster* object, red band of remote sensing imagery}

\item{NDVI}{Raster* object, NDVI calculated from remote sensing imagery}
}
\value{
RasterLayer
}
\description{
This function calculates Land Surface Emissivity according to Sobrino et al. 2008
}
\examples{
red <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(red) = runif(10000, min=0.1, max=0.4)
NDVI <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_Sobrino(red = red, NDVI = NDVI)
}
