% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_tests.R
\name{binomial_p_one_way}
\alias{binomial_p_one_way}
\title{Test equality of ps from binomial distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
binomial_p_one_way(x, n, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector indicating number of successes per group.}

\item{n}{a numeric vector indicating number of attempts per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test equality of ps from binomial distributions.
}
\examples{
library(LRTesteR)

# Null is true.
set.seed(1)
x <- rbinom(3, 50, .5)
n <- rep(50, length(x))
fctr <- factor(1:length(x))
binomial_p_one_way(x, n, fctr, .95)

# Null is false
set.seed(1)
x <- rbinom(3, 50, c(.25, .50, .75))
n <- rep(50, length(x))
fctr <- factor(1:length(x))
binomial_p_one_way(x, n, fctr, .95)
}
