% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarTimebyID_m1.R
\name{VarTimebyID}
\alias{VarTimebyID}
\title{Extracting the start or end time}
\usage{
VarTimebyID(data, id.var, time.var, event.var, name.var.time, new.name)
}
\arguments{
\item{data}{data frame}

\item{id.var}{vector of unique identification}

\item{time.var}{vector with the time variable}

\item{event.var}{vector with the events}

\item{name.var.time}{name of the time string to filter (ex.: "START_ITEM" or
"END_ITEM")}

\item{new.name}{name of the output variable}
}
\value{
a data frame with `time` replaced with `new.name`. The variable
  `event.var` is dropped.
}
\description{
Extracting the start or end time
}
\examples{
# Data preparation
df <- cp025q01
df$id <- paste(df[, 1], df[, 2], df[, 3], sep = "-")
df <- m0$TrimVar(df, c("event", "event_type", "diag_state"))
df <- m0$ConcatActions(df, c(rlang::quo(event), rlang::quo(event_type)))
df <- m0$CleanActions(df, event.type, c("ACER_EVENT_" = ""))

# Function demonstration
m1$VarTimebyID(df, id, time, new.event.type, "START_ITEM", "start")

}
