% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF_lm_ss.R
\name{PF_lm_ss}
\alias{PF_lm_ss}
\title{Parameter Estimation Of Linear Regression Using Particle Filters With Simple Sampling}
\usage{
PF_lm_ss(
  Y,
  Data1,
  n = 500L,
  sigma_l = 1,
  sigma_est = FALSE,
  initDisPar,
  lbd = 2
)
}
\arguments{
\item{Y}{numeric. The response variable}

\item{Data1}{matrix. The matrix containing the independent variables}

\item{n}{integer. Number of particles, by default 500}

\item{sigma_l}{The variance of the normal likelihood, 1 by default}

\item{sigma_est}{logical. If \code{TRUE} takes the last row of \code{initDisPar} as prior estimation of the standard deviation, see more in \emph{Details}}

\item{initDisPar}{matrix. Values a, b of the uniform distribution (via \code{runif}) for each parameter to be estimated, see more in \emph{Details}}

\item{lbd}{numeric. A number to be added and substracted from the priors when \code{initDisPar} is not provided}
}
\value{
A list containing the following elemnts:

\code{stateP_res}: A list of matrices with the PF estimation of the parameters on each observation; the number of rows is the number of observations in \code{Data1} and the number of columns is \code{n}.

\code{Likel}: A matrix with the likelihood of each particle obtained on each observation.
}
\description{
Estimation of the coefficients of a linear regression based on the particle filters algorithm. This function is similar to \code{PF_lm} except for the resampling method which in this case is the simple sampling.
As a result, the user can try higher number of particles.
}
\details{
Estimation of the coefficients of a linear regression:

\eqn{Y = \beta_0  + \beta_1*X_1 + ... + \beta_n*X_n  + \epsilon},  (\eqn{\epsilon \sim N(0,1)})

using particle filter methods.
The state-space equations are:

\eqn{(Eq. 1) X_{k} = a_0 + a_1 * X1_{k-1} + ... + a_n * Xn_{k-1}}

\eqn{(Eq. 2) Y_{k} = X_{k} + \epsilon,  \epsilon \sim N(0,\sigma)}

where, k = 2, ... , number of observations; \eqn{a_0, ... , a_n} are the parameters to be estimated (coefficients), and \eqn{\sigma = 1 }.

The priors of the parameters are assumed uniformly distributed. \code{initDisPar} is a matrix for which the number of rows is the number of independent variables plus one when \code{sigma_est = FALSE},
(plus one since we also estimate the constant term of the regression), or plus two when \code{sigma_est = TRUE} (one for the constant term of the regression, and one for the estimation of sigma).
The first and second column of \code{initDisPar} are the corresponding arguments \code{a} and \code{b} of the uniform distribution (\code{stats::runif}) of each parameter prior.
The first row \code{initDisPar} is the prior guess of the constant term. The following rows are the prior guesses of the coefficients.
When sigma is estimated, i.e., if \code{sigma_est = TRUE} the last row of \code{initDisPar} corresponds to the prior guess for the standard deviation.
If \code{sigma_est = FALSE}, then the standard deviation of the likelihood is \code{sigma_l}.
If \code{sigma_est = TRUE}, the algorithm estimates the standard deviation of \eqn{\epsilon} together with the coefficients.
If \code{initDisPar} is missing, the initial priors are taken using \code{lm()} and \code{coeff()} plus-minus \code{lbd} as a reference.

The resampling method used corresponds to the simple sampling, i.e., we take a sample of \code{n} particles with probability equals the likelihood computed on each iteration.
In addition, on each iteration white noise is added to avoid particles to degenerate.

In case no \code{Data1} is provided, a synthetic data set is generated automatically taking three normal i.i.d. variables, and the dependent variable is computed as in
\eqn{Y = 2 + 1.25*X_1 + 2.6*X_2 - 0.7*X_3 + \epsilon}
}
\examples{

\dontrun{
#### Using default Data1, no sigma estimation ####
Res <- PF_lm_ss(n = 10000L, sigma_est = FALSE) #10 times more than in PF_lm
lapply(Res,class) # Structure of returning list.
###Summary of estimated parameters
Res$summ
#Evolution of the estimated parameters
par(mfrow=c(2, 2))
for (i in 1:4){
plot(apply(Res$stateP_res[[i]],1,mean), main = colnames(Res$summ)[i], col="blue",
      xlab =  "", ylab = "",type="l")
}


#### Using default Data1, with sigma estimation ####
Res2 <- PF_lm_ss(n = 1000L, sigma_est = TRUE)
lapply(Res2,class) # Structure of returning list
###Summary of the estimated parameters
Res2$summ
#Evolution of the estimated parameters
par(mfrow=c(2, 3))
for (i in 1:5){
plot(apply(Res2$stateP_res[[i]],1,mean), main = colnames(Res2$summ)[i], col="blue",
       xlab =  "", ylab = "",type="l")
}


#### Using default Data1, given initDisPar ####
b0 <- matrix(c(1.9, 2, # Prior of a_0
               1, 1.5, # Prior of a_1
               2, 3,   # Prior of a_2
               -1, 0),  # Prior of a_3
               ncol = 2, byrow = TRUE )
Res3 <- PF_lm_ss(n = 10000L, sigma_est = FALSE, initDisPar = b0)
lapply(Res3,class) # Structure of returning list.
###Summary of the estimated parameters
Res3$summ
#Evolution of the estimated parameters
par(mfrow=c(2, 2))
for (i in 1:4){
plot(apply(Res3$stateP_res[[i]],1,mean), main = colnames(Res3$summ)[i], col="blue",
    xlab =  "", ylab = "",type="l")
    }
}

}
\references{
Ristic, B., Arulampalam, S., Gordon, N. (2004). Beyond the Kalman filter: particle filters for tracking applications. Boston, MA: Artech House. ISBN: 158053631X.

West, M., Harrison, J. (1997). Bayesian forecasting and dynamic models (2nd ed.). New York: Springer. ISBN: 0387947256.
}
\author{
Christian Llano Robayo, Nazrul Shaikh.
}
