% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoef.R
\name{getCoef}
\alias{getCoef}
\title{Extract Model Coefficients With Confidence Intervals}
\usage{
getCoef(object, conf.level, effects, format, add.type, ...)
}
\arguments{
\item{object}{a \code{lm}, \code{gls}, \code{lme}, or \code{lmm} object.}

\item{conf.level}{[numeric 0-1] Confidence level of the confidence intervals.}

\item{effects}{[character vector] Type of coefficient to be output.
Can be coefficients relative to the expectation of the outcome (\code{"mean"} or \code{"fixed"})
or to the variance-covariance structure of the residuals (\code{"variance"}).}

\item{format}{[character] How the output should be shaped.
Can be \code{"default"}, \code{"estimate"}, \code{"publish"}, or \code{"SAS"}.}

\item{add.type}{[logical] Should the type of parameter be added.}

\item{...}{argument passed to the \code{publish} function (when \code{format="publish"}).}
}
\value{
A data.frame or a vector (see details section)
}
\description{
Extract all model coefficients with confidence intervals.
}
\details{
Argument \bold{format}: \cr
Setting the argument to \code{"default"} outputs a data.frame with columns type (mean or covariance),
term (name of the coefficient), estimate, std.error, t.value, p.value, lower, upper.

Setting the argument to \code{"publish"} outputs a data.frame with columns Variable, Units Coefficients, CI, and p-value.
Call the function \code{publish} from the \code{publish} package.

Setting the argument to \code{"estimate"} outputs a vector containing the estimated parameter values.
                                    
Argument \bold{add.type}: \cr
When \code{TRUE}, there can be 4 types of parameters in the output: \itemize{
\item \code{"mean"}: coefficients relative to the conditional mean of the outcome given the covariates. 
\item \code{"std.residual"}: (reference) residual standard deviation.
\item \code{"factor.std.residual"}: multiplicative factor to the residual standard deviation.
\item \code{"correlation"}: correlation coefficient between the residuals.
\item \code{"std.random"}: standard error of the random effects.
}
}
\examples{
data(gastricbypassL, package = "LMMstar")
library(nlme)

#### linear model ####
## (wrong model as it does not account for repeated measurements)
e.lm <- lm(weight ~ time, data = gastricbypassL)

getCoef(e.lm)
getCoef(e.lm, format = "estimate")
getCoef(e.lm, effects = "variance")
getCoef(e.lm, effects = "variance", format = "estimate")
if(require(Publish)){
getCoef(e.lm, format = "publish")
}
getCoef(e.lm, format = "SAS")

#### gls model ####
e.gls <- gls(weight ~ time,
             correlation = corSymm(form =~as.numeric(visit)|id),
             weights = varIdent(form =~1|visit),
             data = gastricbypassL)
getCoef(e.gls)
getCoef(e.gls, effects = "variance")
getCoef(e.gls, effects = "variance", format = "estimate")
if(require(Publish)){
getCoef(e.gls, format = "publish")
}
getCoef(e.gls, format = "SAS")

#### lme model ####
e.lme <- lme(weight ~ time,
             random = ~1|id,
             weights = varIdent(form =~1|visit),
             data = gastricbypassL)
getCoef(e.lme)
getCoef(e.lme, effects = "variance")
getCoef(e.lme, effects = "variance", format = "estimate")
if(require(Publish)){
getCoef(e.lme, format = "publish")
}
getCoef(e.lme, format = "SAS")
}
