% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_feature_engineering_agent.R
\name{build_feature_engineering_agent}
\alias{build_feature_engineering_agent}
\title{Build a Feature Engineering Agent}
\arguments{
\item{model}{A function that accepts a prompt and returns an LLM-generated response.}

\item{human_validation}{Logical; include a manual review node before code execution.}

\item{bypass_recommended_steps}{Logical; skip the LLM-based recommendation phase.}

\item{bypass_explain_code}{Logical; skip final explanation step.}

\item{verbose}{Logical; whether to print progress messages (default: TRUE)}
}
\value{
A callable agent function that executes feature engineering via a state graph.
}
\description{
Constructs a graph-based feature engineering agent that guides the process of:
recommending, generating, executing, fixing, and explaining feature engineering code.
}
\examples{
\dontrun{
state <- list(
  data_raw = iris,
  target_variable = "Species"
)
agent <- build_feature_engineering_agent(model = call_llm)
agent(state)
str(state$data_engineered)
}
}
