% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKTfunctions.R
\name{buildLKTModel}
\alias{buildLKTModel}
\title{buildLKTModel}
\usage{
buildLKTModel(
  data,
  allcomponents,
  allfeatures,
  currentcomponents = c(),
  specialcomponents = c(),
  specialfeatures = c(),
  forv,
  bacv,
  preset = NA,
  presetint = T,
  currentfeatures = c(),
  verbose = FALSE,
  traceCV = TRUE,
  currentfixedpars = c(),
  maxitv = 10,
  interc = FALSE,
  forward = TRUE,
  backward = TRUE,
  metric = "BIC"
)
}
\arguments{
\item{data}{is a dataset with Anon.Student.Id and CF..ansbin.}

\item{allcomponents}{is search space for LKT components}

\item{allfeatures}{is search space for LKT features}

\item{currentcomponents}{components to start search from}

\item{specialcomponents}{add special components (not crossed with features, only paired with special features 1 for 1)}

\item{specialfeatures}{features for each special component (not crossed during search)}

\item{forv}{the minimuum amount of improvement needed for the addition of a new term}

\item{bacv}{the maximuum amount of loss for a term to be removed}

\item{preset}{One of "static","AFM","PFA","advanced","AFMLLTM","PFALLTM","advancedLLTM"}

\item{presetint}{should the intercepts be included for preset components}

\item{currentfeatures}{features to start search from}

\item{verbose}{passed to LKT}

\item{traceCV}{produce a CV fromt he LKT method at the beginnign of each cycle}

\item{currentfixedpars}{used for current features as an option to start}

\item{maxitv}{passed to LKT}

\item{interc}{passed to LKT}

\item{forward}{TRUE or FALSE}

\item{backward}{TRUE or FALSE}

\item{metric}{One of "BIC","AUC","AIC", and "RMSE"}
}
\value{
list of values "tracetable" and "currentfit"
}
\description{
Forward and backwards stepwise search for a set of features and components

with tracking of nonlinear parameters.
}
