\name{threshold}
\alias{threshold}
\title{Threshold a matrix/vector below and above}
\usage{
threshold(x, min = -Inf, max = Inf)
}
\arguments{
  \item{x}{a numeric matrix(like object)}

  \item{min}{minimum value}

  \item{max}{maximum value}
}
\description{
  \code{threshold} sets values of a vector/matrix below
  \code{min} to \code{min}; values above \code{max} are set
  to \code{max}.

  \code{threshold} is mainly used to project sparsified
  weight vectors (\code{\link{sparsify_weights}}) back onto
  the probability simplex (thus \code{min = 0} and then
  \code{\link{normalize}}).
}
\examples{
print(threshold(c(1, 4, 2, -1, 10), min = 0))
}
\seealso{
  \code{\link{normalize}}
}
\keyword{array}
\keyword{manip}
