% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OA2LHD.R
\name{OA2LHD}
\alias{OA2LHD}
\title{Transfer an Orthogonal Array (OA) into an LHD}
\usage{
OA2LHD(OA)
}
\arguments{
\item{OA}{An orthogonal array matrix.}
}
\value{
If the input is logical, then the output will be an LHD whose sizes are the same as input OA. The assumption is that the elements of OAs must be positive.
}
\description{
\code{OA2LHD} transfers an OA into an LHD with corresponding size
}
\examples{
#create an OA(9,2,3,2)
OA=matrix(c(rep(1:3,each=3),rep(1:3,times=3)),ncol=2,nrow=9,byrow = FALSE);OA

#Transfer the "OA" above into a LHD according to Tang (1993)
tryOA=OA2LHD(OA)
OA;tryOA
}
\references{
Tang, B. (1993) Orthogonal-array-based latin hypercubes. \emph{Journal of the Americal Statistical Association}, \strong{88}, 1392-1397.
}
