% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{plot.LEGIT}
\alias{plot.LEGIT}
\title{Plot}
\usage{
\method{plot}{LEGIT}(x, cov_values = NULL, gene_quant = c(0.025, 0.5,
  0.975), env_quant = c(0.025, 0.5, 0.975), outcome_quant = c(0.025, 0.5,
  0.975), cols = c("#3288BD", "#CAB176", "#D53E4F"), ylab = "Outcome",
  xlab = "Environment", leglab = "Genetic score", xlim = NULL,
  ylim = NULL, x_at = NULL, y_at = NULL, cex.axis = 1.9, cex.lab = 2,
  cex.main = 2.2, cex.leg = 2.2, legend = "topleft", ...)
}
\arguments{
\item{x}{An object of class "LEGIT", usually, a result of a call to LEGIT.}

\item{cov_values}{Vector of the values, for each covariate, that will be used in the plotting, if there are any covariates. It must contain the names of the variables. Covariates are the variables that are not \emph{G} nor \emph{E} but still are adjusted for in the model. By default, covariates are fixed to the mean.}

\item{gene_quant}{Vector of the genes quantiles used to make the plot. We use quantiles instead of fixed values because genetic scores can vary widely depending on the weights, thus looking at quantiles make this simpler. (Default = c(.025,.50,.975))}

\item{env_quant}{Vector of the environments quantiles used to make the plot. We use quantiles instead of fixed values because environmental scores can vary widely depending on the weights, thus looking at quantiles make this simpler. (Default = c(.025,.50,.975))}

\item{outcome_quant}{Vector of the outcome quantiles used to make the plot. We use quantiles instead of fixed values because environmental scores can vary widely depending on the weights, thus looking at quantiles make this simpler. (Default = c(.025,.50,.975))}

\item{cols}{Colors for the slopes with different genetic score. Must be a vector same length as "gene_range". (Default = c("#3288BD", "#CAB176", #D53E4F"))}

\item{ylab}{Y-axis label (Default = "Outcome")}

\item{xlab}{X-axis label (Default = "Environment")}

\item{leglab}{Legend for the genes slopes label (Default = "Genetic score")}

\item{xlim}{X-axis vector of size two with min and max (Default = NULL which leads to min="2.5 percentile" and max="97.5 percentile").}

\item{ylim}{Y-axis vector of size two with min and max (Default = NULL which leads to min="2.5 percentile" and max="97.5 percentile").}

\item{x_at}{specific ticks for the X-axis, first and last will be min and max respectively (Default = NULL which leads to 2.5, 50 and 97.5 percentiles).}

\item{y_at}{specific ticks for the Y-axis, first and last will be min and max respectively (Default = NULL which leads to 2.5, 50 and 97.5 percentiles).}

\item{cex.axis}{relative scale of axis (Default = 1.9)}

\item{cex.lab}{relative scale of labels (Default = 2)}

\item{cex.main}{relative scale overall (Default = 2.2)}

\item{cex.leg}{relative scale of legend (Default = 2.2)}

\item{legend}{The location may of the legend be specified by setting legend to a single keyword from the list "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center" (Default = "topleft").}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns a list containing the different models (diathesis-stress, differential susceptibility and vantage sensitivity WEAK or STRONG) in order from best to worst for each selected criterion.
}
\description{
Plot of LEGIT models. By default, variables that are not in \emph{G} or \emph{E} are fixed to the mean.
}
\examples{
train = example_2way(500, 1, seed=777)
fit = LEGIT(train$data, train$G, train$E, y ~ G*E, train$coef_G, train$coef_E)
plot(fit)
}
\references{
Alexia Jolicoeur-Martineau, Ashley Wazana, Eszter Szekely, Meir Steiner, Alison S. Fleming, James L. Kennedy, Michael J. Meaney, Celia M.T. Greenwood and the MAVAN team. \emph{Alternating optimization for GxE modelling with weighted genetic and environmental scores: examples from the MAVAN study} (2017). arXiv:1703.08111.
}
