% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_table.R
\name{LDA_table}
\alias{LDA_table}
\title{LDA_table}
\usage{
LDA_table(x, ref_class = "unknown", uncertainty = "act")
}
\arguments{
\item{x}{numeric data.frame or matrix with at least three columns (cells,
wells, positive wells, group (optional))}

\item{ref_class}{name of reference class for calculation of SF values}

\item{uncertainty}{method for calculating the uncertainty bands of survival
fractions ("act" (default) for combining the activity confidence intervals;
"ep" for error propagation via first order Taylor series expansion.)}
}
\value{
table
}
\description{
show table with activities and clonogenic survival from limiting
  dilution assay (LDA) data.
}
\examples{
x <- data.frame("cells" = c(10,50,100,250,10,50,100,250),
                "wells" = rep(25,8),
                "positive" = c(2,5,10,20,1,2,6,11),
                "group" = c(rep("A",4),rep("B",4)))
LDA_table(x,ref_class = "A")
}
