% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_float.R
\name{fit_float}
\alias{fit_float}
\title{Central fitting function with float environment}
\usage{
fit_float(all.samples, all.standards, LC.vals, float, ex.smaller = NULL,
  file.output = NULL, best.fits = NULL)
}
\arguments{
\item{all.samples}{List of all samples}

\item{all.standards}{List of all standards}

\item{LC.vals}{The fitting range values for the linear combination fitting}

\item{float}{Let vary the energy range paramerters}

\item{ex.smaller}{Exclude portions smaller than a given value (decimal form), default to NULL}

\item{file.output}{Possibility to have a file output, default to NULL}

\item{best.fits}{Possibility to output more than the best fit (e.g. the first 10 best fits), default to 1}
}
\description{
This function allows to process all samples, especially written for the float environment.
}
\examples{
data(stdmix)
corr.spec.standards  <- initial_load(specdat[1:4], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec.samples    <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
## Select parameters for baseline correction and edge-step normalization
param.float <- expand.grid(pre.adj.1 = seq(-42,-30,6), 
  pre.adj.2 = seq(-19,-9,5), post.adj.1 = seq(35,40,5), 
  post.adj.2 = seq(50,65,5))
length(param.float[,1])
float.fit <- fit_float(all.samples = corr.spec.samples,
  all.standards = corr.spec.standards, 
  LC.vals = c(-14, 46), float = param.float, best.fits = 20)
print(float.fit)

###### Using next configuration can be very time consuming 

param.float.2 <- expand.grid(pre.adj.1 = seq(-43,-30,1), 
  pre.adj.2 = seq(-19,-9,.5), post.adj.1 = seq(34,40,.5), 
  post.adj.2 = seq(50,65,1))
}
\keyword{float}
\keyword{parameters}
