% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single-attribute-value-functions.R
\name{SAVF_plot_rho_error}
\alias{SAVF_plot_rho_error}
\title{Plot the rho squared error terms}
\usage{
SAVF_plot_rho_error(desired_x, desired_v, x_low, x_high, rho_low = 0,
  rho_high = 1)
}
\arguments{
\item{desired_x}{Elicited input x value(s)}

\item{desired_v}{Elicited value score related to elicited input value(s)}

\item{x_low}{Lower bound anchor point (can be different than \code{min(x)})}

\item{x_high}{Upper bound anchor point (can be different than \code{max(x)})}

\item{rho_low}{Lower bound of the exponential constant search space for a best fit value function}

\item{rho_high}{Upper bound of the exponential constant search space for a best fit value function}
}
\value{
A plot that visualizes the squared error terms for the rho search space
}
\description{
\code{SAVF_plot_rho_error} plots the squared error terms for the rho search
space to illustrate the preferred rho that minimizes the squared error
between subject matter desired values and exponentially fitted scores
}
\examples{

# Given the single attribute x is bounded between 1 and 5 and the subject matter experts
# prefer x values of 3, 4, & 5 provide a utility score of .75, .90 & 1.0 respectively, we
# can visualize the error terms for rho values between 0-1:

SAVF_plot_rho_error(desired_x = c(3, 4, 5),
                    desired_v = c(.75, .9, 1),
                    x_low = 1,
                    x_high = 5,
                    rho_low = 0,
                    rho_high = 1)

}
\seealso{
\code{\link{SAVF_preferred_rho}} for identifying the preferred rho value

\code{\link{SAVF_score}} for computing the exponential single attribute value score
}
