/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.IrregularUtil;
import org.apache.lucene.analysis.kr.utils.SyllableUtil;

public class MorphUtil {
    private static final char[] CHOSEONG = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    private static final char[] JUNGSEONG = new char[]{'\u314f', '\u3150', '\u3151', '\u3152', '\u3153', '\u3154', '\u3155', '\u3156', '\u3157', '\u3158', '\u3159', '\u315a', '\u315b', '\u315c', '\u315d', '\u315e', '\u315f', '\u3160', '\u3161', '\u3162', '\u3163'};
    private static final char[] JONGSEONG;
    private static final int JUNG_JONG;

    static {
        char[] cArray = new char[28];
        cArray[1] = 12593;
        cArray[2] = 12594;
        cArray[3] = 12595;
        cArray[4] = 12596;
        cArray[5] = 12597;
        cArray[6] = 12598;
        cArray[7] = 12599;
        cArray[8] = 12601;
        cArray[9] = 12602;
        cArray[10] = 12603;
        cArray[11] = 12604;
        cArray[12] = 12605;
        cArray[13] = 12606;
        cArray[14] = 12607;
        cArray[15] = 12608;
        cArray[16] = 12609;
        cArray[17] = 12610;
        cArray[18] = 12612;
        cArray[19] = 12613;
        cArray[20] = 12614;
        cArray[21] = 12615;
        cArray[22] = 12616;
        cArray[23] = 12618;
        cArray[24] = 12619;
        cArray[25] = 12620;
        cArray[26] = 12621;
        cArray[27] = 12622;
        JONGSEONG = cArray;
        JUNG_JONG = JUNGSEONG.length * JONGSEONG.length;
    }

    public static char[] decompose(char c) {
        char[] result = null;
        if (c > '\ud7a3' || c < '\uac00') {
            return new char[]{c};
        }
        c = (char)(c - 44032);
        char choseong = CHOSEONG[c / JUNG_JONG];
        c = (char)(c % JUNG_JONG);
        char jungseong = JUNGSEONG[c / JONGSEONG.length];
        char jongseong = JONGSEONG[c % JONGSEONG.length];
        result = jongseong != '\u0000' ? new char[]{choseong, jungseong, jongseong} : new char[]{choseong, jungseong};
        return result;
    }

    public static char compound(int first, int middle, int last) {
        return (char)(44032 + first * JUNG_JONG + middle * JONGSEONG.length + last);
    }

    public static char makeChar(char ch, int mdl, int last) {
        ch = (char)(ch - 44032);
        int first = ch / JUNG_JONG;
        return MorphUtil.compound(first, mdl, last);
    }

    public static char makeChar(char ch, int last) {
        ch = (char)(ch - 44032);
        int first = ch / JUNG_JONG;
        ch = (char)(ch % JUNG_JONG);
        int middle = ch / JONGSEONG.length;
        return MorphUtil.compound(first, middle, last);
    }

    public static char replaceJongsung(char dest, char source) {
        source = (char)(source - 44032);
        int last = source % JONGSEONG.length;
        return MorphUtil.makeChar(dest, last);
    }

    public static String buildTypeString(String word, char type) {
        StringBuffer sb = new StringBuffer();
        sb.append(word);
        sb.append("(");
        sb.append(type);
        sb.append(")");
        return sb.toString();
    }

    public static void buildPtnVM(AnalysisOutput output, List candidates) throws MorphException {
        String end = output.getEomi();
        if (output.getPomi() != null) {
            end = output.getPomi();
        }
        output.setPatn(11);
        output.setPos('V');
        if (output.getScore() == 100) {
            candidates.add(output);
        } else {
            String[] irrs = IrregularUtil.restoreIrregularVerb(output.getStem(), end);
            if (irrs != null) {
                output.setScore(100);
                output.setStem(irrs[0]);
                candidates.add(output);
            }
        }
    }

    public static void buildPtnCM(AnalysisOutput output, List candidates) throws MorphException {
        char ch = output.getStem().charAt(output.getStem().length() - 2);
        char[] jasos = MorphUtil.decompose(ch);
        if (jasos.length == 3 || ch == '\uae30') {
            MorphUtil.buildPtnVMCM(output, candidates);
        }
    }

    private static void buildPtnVMCM(AnalysisOutput output, List candidates) throws MorphException {
        String stem = output.getStem();
        output.setPatn(13);
        output.setPos('V');
        char ch = stem.charAt(stem.length() - 2);
        char[] jasos = MorphUtil.decompose(ch);
        if (ch == '\uae30') {
            output.addElist("\uae30");
            output.addElist("\uc774");
            output.setStem(stem.substring(0, stem.length() - 2));
            if (DictionaryUtil.getVerb(output.getStem()) != null) {
                candidates.add(output);
            }
        } else if (jasos[2] == '\u3141') {
            if (stem.length() > 1) {
                stem = stem.substring(0, stem.length() - 2);
            }
            stem = String.valueOf(stem) + MorphUtil.makeChar(ch, 0);
            output.addElist("\u3141");
            output.addElist("\uc774");
            output.setStem(stem);
            if (DictionaryUtil.getVerb(stem) != null) {
                candidates.add(output);
            } else {
                String[] morphs = IrregularUtil.restoreIrregularVerb(stem, "\u3141");
                if (morphs != null) {
                    output.setScore(100);
                    output.setStem(morphs[0]);
                    candidates.add(output);
                }
            }
        }
    }

    public static boolean hasVerbOnly(String input) throws MorphException {
        int i = input.length() - 1;
        while (i >= 0) {
            char[] feature = SyllableUtil.getFeature(input.charAt(i));
            if (feature[SyllableUtil.IDX_WDSURF] == '1' && input.length() > i) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static String makeTesnseEomi(String preword, String endword) {
        if (preword == null || preword.length() == 0) {
            return endword;
        }
        if (endword == null || endword.length() == 0) {
            return preword;
        }
        if (endword.charAt(0) == '\u3146') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 20) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3134') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 4) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3139') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 8) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3141') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 16) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3142') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 17) + endword.substring(1, endword.length());
        }
        return String.valueOf(preword) + endword;
    }

    public static boolean isValidSuffix(WordEntry entry, AnalysisOutput o) {
        return true;
    }
}

