/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.thread;

import java.util.concurrent.LinkedBlockingQueue;
import kr.ac.kaist.swrc.jhannanum.comm.PlainSentence;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.PlainTextProcessor;

public class PlainTextProcThread
extends Thread {
    private PlainTextProcessor plainTextProcessor = null;
    private LinkedBlockingQueue<PlainSentence> in;
    private LinkedBlockingQueue<PlainSentence> out;

    public PlainTextProcThread(PlainTextProcessor plainTextProcessor, LinkedBlockingQueue<PlainSentence> in, LinkedBlockingQueue<PlainSentence> out) {
        this.plainTextProcessor = plainTextProcessor;
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        PlainSentence ps = null;
        try {
            while (true) {
                ps = this.in.take();
                if ((ps = this.plainTextProcessor.doProcess(ps)) != null) {
                    this.out.add(ps);
                }
                while (this.plainTextProcessor.hasRemainingData()) {
                    ps = this.plainTextProcessor.doProcess(null);
                    if (ps == null) continue;
                    this.out.add(ps);
                }
                ps = this.plainTextProcessor.flush();
                if (ps == null) continue;
                this.out.add(ps);
            }
        }
        catch (InterruptedException e) {
            this.plainTextProcessor.shutdown();
            return;
        }
    }
}

