% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KbSkewness.R
\name{kbMvtSkew}
\alias{kbMvtSkew}
\title{Khattree-Bahuguna's Multivariate Skewness}
\usage{
kbMvtSkew(x)
}
\arguments{
\item{x}{a matrix of original observations.}
}
\value{
\code{kbMvtSkew} computes the Khattree-Bahuguna's multivairate skewness for a \eqn{p}-dimensional data.
}
\description{
Compute Khattree-Bahuguna's Multivariate Skewness.
}
\details{
Let \eqn{\mathbf{X}=(X_1,\ldots,X_p)'} be the multivariate random vector and \eqn{(X_{i_1}, X_{i_2}, \ldots, X_{i_p})'} be one of the \eqn{p!} permutations of \eqn{(X_1,\ldots,X_p)'}. We predict \eqn{X_{i_j}} conditionally on subvector \eqn{(X_{i_1}, \ldots,X_{i_{j-1}})} and compute the corresponding residual \eqn{V_{i_j}} through a linear regression model for \eqn{j = 2, \cdots, p}. For \eqn{j=1}, we define \eqn{V_{i_1} = X_{i_1} - \bar{X}_{i_1}}, where \eqn{\bar{X}_{i_1}} is the mean of \eqn{X_{i_1}}. For \eqn{j \ge 2}, we have
\deqn{\hat{X}_{i_2}  = \hat{\beta}_0 + \hat{\beta}_1 X_{i_1}, \quad V_{i_2} = X_{i_2} - \hat{X}_{i_2}}
\deqn{\hat{X}_{i_3} = \hat{\beta}_0 + \hat{\beta}_1 X_{i_1} + \hat{\beta}_2 X_{i_2}, \quad V_{i_3} = X_{i_3} - \hat{X}_{i_3}}
\deqn{\vdots}
\deqn{\hat{X}_{i_p} = \hat{\beta}_0 + \hat{\beta}_1 X_{i_1} + \hat{\beta}_2 X_{i_2} + \cdots + \hat{\beta}_{p-1} X_{i_{p-1}}, \quad V_{i_p} = X_{i_p} - \hat{X}_{i_p}.}

We calculate the sample skewness \eqn{\hat{\delta}_{i_j}} of \eqn{V_{i_j}} by the sample Khattree-Bahuguna's univariate skewness formula (see details of \code{\link{kbSkew}} that follows) respectively for \eqn{j=1,\cdots,p} and define \eqn{\hat{\Delta}_{i} = \sum_{j=1}^{p} \hat{\delta}_{i_j}, i = 1, 2, \ldots, P} for all \eqn{P = p!} permutations of \eqn{(X_1,\ldots,X_p)'}. The sample Khattree-Bahuguna's multivariate skewness is defined as
\deqn{\hat{\Delta} = \frac{1}{P} \sum_{i=1}^{P} \hat{\Delta}_{i}.}
Clearly, \eqn{0 \le \hat{\Delta} \le \frac{p}{2}}.
}
\examples{
# Compute Khattree-Bahuguna's multivairate skewness

data(OlymWomen)
kbMvtSkew(OlymWomen[, c("m800","m1500","m3000","marathon")])

}
\references{
Khattree, R. and Bahuguna, M. (2019). An alternative data analytic approach to measure the univariate and multivariate skewness. \emph{International Journal of Data Science and Analytics}, Vol. 7, No. 1, 1-16.
}
\seealso{
\code{\link{kbSkew}} for Khattree-Bahuguna's univariate skewness.
}
