% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HHGKM_2_sample.R
\name{konp_2_sample_impu_output}
\alias{konp_2_sample_impu_output}
\title{KONP Test for Equality of Two Distributions for Right Censored Data}
\usage{
konp_2_sample_impu_output(time, status, group, n_perm, n_impu = 1)
}
\arguments{
\item{time}{A vector of the observed follow-up times.}

\item{status}{A vector of event indicators, 0=right censored, 1= event at \code{time}.}

\item{group}{A vector denoting the group labels, must contain at least two different values.}

\item{n_perm}{The number of permutations.}

\item{n_impu}{The number of imputations, for each imputation n_perm permutations will be executed.}
}
\value{
Three test statistics and their respective p-values are returned: \cr 

\code{pv_chisq} - returns the p-value based on the KONP test chi-square statistic. \cr 
\code{pv_lr} - returns the p-value based on the KONP test likelihood ratio statistic. \cr 
\code{pv_cauchy} - returns the p-value based on the KONP-based Cauchy-combination test statistic. \cr 
\code{chisq_test_stat} - returns the KONP test chi-squared test statistic. \cr 
\code{lr_test_stat} - returns the KONP test likelihood-ratio test statistic. \cr
\code{cauchy_test_stat} - returns the KONP-based Cauchy-combination test statistic.
}
\description{
KONP Test for Equality of Two Distributions for Right Censored Data
}
\details{
This is inner funtion inside KONP package made only for running simulation and not for users
}
