/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.DataStructures.Data.Viewers;

import java.awt.Component;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.omegahat.DataStructures.Data.FactorInt;
import org.omegahat.DataStructures.Data.VariableInt;
import org.omegahat.DataStructures.Data.Viewers.DataFrameTableModel;

public class FactorCellEditor
extends JComboBox
implements TableCellEditor {
    protected static final int STOP = 0;
    protected static final int CANCEL = 1;
    protected FactorInt activeVariable;
    protected int activeObservation;
    protected Vector listeners;

    public FactorCellEditor() {
        this.setEditable(true);
    }

    public int activeObservation() {
        return this.activeObservation;
    }

    public int activeObservation(int n) {
        this.activeObservation = n;
        return this.activeObservation;
    }

    public FactorInt activeVariable() {
        return this.activeVariable;
    }

    public FactorInt activeVariable(FactorInt factorInt) {
        this.activeVariable = factorInt;
        return this.activeVariable;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners().addElement(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.notifyListeners(1);
    }

    public JComboBox editor() {
        return this;
    }

    public Object getCellEditorValue() {
        return this.editor().getSelectedItem();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        VariableInt variableInt;
        if (jTable.getModel() instanceof DataFrameTableModel && (variableInt = ((DataFrameTableModel)jTable.getModel()).getVariable(n2)) instanceof FactorInt) {
            Object[] objectArray = ((FactorInt)variableInt).levels().levels();
            if (this.getItemCount() > 0) {
                this.editor().removeAllItems();
            }
            int n3 = 0;
            while (n3 < objectArray.length) {
                this.editor().addItem(objectArray[n3]);
                ++n3;
            }
            this.editor().setSelectedItem(object.toString());
            this.activeVariable((FactorInt)variableInt);
            this.activeObservation(n);
            return this.editor();
        }
        return new TextField(object.toString());
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public Vector listeners() {
        return this.listeners(true);
    }

    public Vector listeners(Vector vector) {
        this.listeners = vector;
        return this.listeners;
    }

    public Vector listeners(boolean bl) {
        if (this.listeners == null && bl) {
            this.listeners(new Vector(1));
        }
        return this.listeners;
    }

    public void notifyListeners(int n) {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.listeners().elements();
        while (enumeration.hasMoreElements()) {
            CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
            if (n == 0) {
                cellEditorListener.editingStopped(changeEvent);
                continue;
            }
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.notifyListeners(0);
        }
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners(false) != null && this.listeners(false).contains(cellEditorListener)) {
            this.listeners().remove(cellEditorListener);
        }
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.notifyListeners(0);
        return true;
    }
}

