/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.Properties;
import org.omegahat.Environment.Tools.VariableExpansion.VariableExpansion;
import org.omegahat.Environment.Utils.TrimmedProperties;

public class SubstitutedTrimmedProperties
extends TrimmedProperties {
    public SubstitutedTrimmedProperties() {
    }

    public SubstitutedTrimmedProperties(File file) throws FileNotFoundException {
        this(file, System.getProperties());
    }

    public SubstitutedTrimmedProperties(File file, Properties properties) throws FileNotFoundException {
        this(new FileReader(file), properties);
    }

    public SubstitutedTrimmedProperties(Reader reader, Properties properties) {
        this.substitute(reader, properties);
    }

    public SubstitutedTrimmedProperties(String string) {
        this(string, System.getProperties());
    }

    public SubstitutedTrimmedProperties(String string, Properties properties) {
        this(new StringReader(string), properties);
    }

    public SubstitutedTrimmedProperties(Properties properties) {
        super(properties);
    }

    public void load(InputStream inputStream) {
        VariableExpansion variableExpansion = new VariableExpansion(inputStream, this.variables());
        String string = variableExpansion.expandString();
        super.load(new StringBufferInputStream(string));
    }

    public String substitute(Reader reader, Properties properties) {
        VariableExpansion variableExpansion = new VariableExpansion(reader, properties);
        String string = variableExpansion.expandString();
        super.load(new StringBufferInputStream(string));
        return string;
    }

    public String substitute(String string, Properties properties) {
        return this.substitute(new StringReader(string), properties);
    }

    public Properties variables() {
        return System.getProperties();
    }
}

