% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearTest.R
\name{linearTest}
\alias{linearTest}
\title{Linear hypothesis testing of joint models}
\usage{
linearTest(
  object,
  coeff = c("beta", "gamma", "alpha"),
  La = "identity",
  Lb = "identity",
  Lg = "identity",
  Ca = 0,
  Cb = 0,
  Cg = 0,
  digits = 4,
  ...
)
}
\arguments{
\item{object}{The JMcmprsk object returned by either jmo or jmc function.}

\item{coeff}{Types of coefficients selected for Wald. Note "alpha" is only avaiable to jmo type JMcmprsk object.}

\item{La}{Linear contrast of the fixed effects of non-proportional odds covariates * (# of levels of the outcome - 2) in the longitudinal part. 
Default is "identity", i.e., all the fixed effects equal to zero. Otherwise, La must be a matrix.}

\item{Lb}{Linear contrast of the fixed effects of proportional odds covariates in the longitudinal part. 
Default is "identity", i.e., all the fixed effects equal to zero. Otherwise, Lb must be a matrix.}

\item{Lg}{Linear contrast of the fixed effects of covariates * # of competing risks in the survival part. 
Default is "identity", i.e., all the fixed effects equal to zero. Otherwise, Lg must be a matrix.}

\item{Ca}{The hypothesized value of linear combination of the fixed effects of non-proportional odds covariates 
* (# of levels of the outcome - 2) in the longitudinal part. Default is 0. Otherwise, Ca must be a number / vector.}

\item{Cb}{The hypothesized value of linear combination of the fixed effects of proportional odds covariates 
in the longitudinal part. Default is 0. Otherwise, Cb must be a number / vector.}

\item{Cg}{The hypothesized value of linear combination of the fixed effects of covariates * # of competing risks in the survival part.
Default is 0. Otherwise, Cg must be a number / vector.}

\item{digits}{number of digits to be printed out.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Return a Wald test statistic and the p value
  \tabular{ll}{
      \code{beta}    \tab  The Wald test for fixed effects for the longitutal part,i.e.  \eqn{\beta} in jmo or jmc output. \cr
      \code{gamma}    \tab  The Wald test for fixed effects for the survival part,i.e.  \eqn{\gamma} in jmo or jmc output.  \cr
      \code{alpha}    \tab  The Wald test for non-proportional odds covariates,i.e.  \eqn{\alpha} in jmo output. \cr
  }
}
\description{
Joint modelling for longitutal and censored data with competing risks
}
\details{
Wald test statistic is used for hypothesis testing on multiple parameters: 

  \eqn{H_0: L\theta = C} vs: \eqn{H_1: L\theta \neq C}

  The test statistic is:
  
  \eqn{(L\hat{\theta} - C)'(L\hat{V_{\theta}}L)^{-1}(L\hat{\theta} - C) \sim \chi_q^2,}
   
  where \eqn{\hat{V_{\theta}}} is the estimate of covariance of the parameter \eqn{\theta} and q is the rank of the linear contrast \eqn{L}.
}
