/*
 * Decompiled with CFR 0.152.
 */
package jedit.syntax;

import java.util.Vector;
import javax.swing.text.Segment;
import jedit.syntax.KeywordMap;
import jedit.syntax.TokenMarker;
import org.rosuda.JGR.JGR;

public class RTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public RTokenMarker() {
        this(true, RTokenMarker.getKeywords());
    }

    public RTokenMarker(boolean cpp, KeywordMap keywords) {
        this.cpp = cpp;
        this.keywords = keywords;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block15: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp) continue block15;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block15;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || ".".indexOf(c) != -1) continue block15;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block15;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (array[i1] != '#') continue block15;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block15;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (c != '\"') continue block15;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (c != '\'') continue block15;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            int i;
            cKeywords = new KeywordMap(false);
            cKeywords.add("in", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("repeat", (byte)6);
            cKeywords.add("next", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("function", (byte)6);
            Vector _keywords = JGR.KEYWORDS;
            for (i = 0; i < _keywords.size(); ++i) {
                cKeywords.add(_keywords.get(i) + "", (byte)6);
            }
            _keywords = JGR.OBJECTS;
            for (i = 0; i < _keywords.size(); ++i) {
                cKeywords.add(_keywords.get(i) + "", (byte)7);
            }
            cKeywords.add("TRUE", (byte)4);
            cKeywords.add("T", (byte)4);
            cKeywords.add("FALSE", (byte)4);
            cKeywords.add("F", (byte)4);
            cKeywords.add("NULL", (byte)4);
            cKeywords.add("NA", (byte)4);
            cKeywords.add("NA_integer_", (byte)4);
            cKeywords.add("NA_real_", (byte)4);
            cKeywords.add("NA_complex_", (byte)4);
            cKeywords.add("NA_character_", (byte)4);
            cKeywords.add("Inf", (byte)4);
            cKeywords.add("NaN", (byte)4);
            cKeywords.add("#", (byte)1);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

