/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.robjects.RModel;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.util.Global;

public class RController {
    public static final String TEMP_MATRIX_DIM_NAMES_JGR = "tempMatrixDimNamesJGR";
    public static final String TEMP_MATRIX_CONTENT_JGR = "tempMatrixContentJGR";
    public static final String TEMP_VARIABLE_NAME = "jgrtemp";
    public static Object dummy = new Object();

    public static String getRHome() {
        try {
            REXP rEXP = JGR.eval("R.home()");
            return rEXP.asString();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return "";
    }

    public static String[] getRLibs() {
        try {
            REXP rEXP = JGR.eval(".libPaths()");
            return rEXP.asStrings();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return null;
    }

    public static String getRPrompt() {
        try {
            REXP rEXP = JGR.eval("try(as.character(options('prompt')),silent=TRUE)");
            return rEXP.asString();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return "> ";
    }

    public static String getRContinue() {
        try {
            REXP rEXP = JGR.eval("try(as.character(options('continue')),silent=TRUE)");
            return rEXP.asString();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return "> ";
    }

    public static String getCurrentPackages() {
        try {
            REXP rEXP = JGR.eval(".packages(TRUE)");
            if (rEXP != null && !rEXP.isNull() && rEXP.asStrings() != null) {
                String string = "";
                for (int i = 0; i < rEXP.asStrings().length - 1; ++i) {
                    string = string + rEXP.asStrings()[i] + ",";
                }
                string = string + rEXP.asStrings()[rEXP.asStrings().length - 1];
                return string;
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return null;
    }

    public static String[] getDefaultPackages() {
        try {
            REXP rEXP = JGR.eval("getOption(\"defaultPackages\")");
            return rEXP.asStrings();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return new String[0];
    }

    public static String[] getJgrDefaultPackages() {
        String string = JGRPrefs.defaultPackages;
        if (string == null) {
            string = "JGR";
        }
        try {
            REXP rEXP = JGR.eval("as.character(unique(c(getOption(\"defaultPackages\"),strsplit(\"" + string + "\",', ?')[[1]],'JGR')))");
            return rEXP.asStrings();
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return new String[0];
    }

    public static void requirePackages(String string) {
        try {
            JGR.getREngine().assign(".$JGR", string);
            JGR.eval("{ for (pkg in strsplit(`.$JGR`,', ?')[[1]]) require(pkg, warn.conflicts=FALSE, character.only=TRUE); rm(`.$JGR`); TRUE }");
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
    }

    public static void loadPackage(String string) {
        String string2 = RController.getCurrentPackages();
        if (!string2.contains(string)) {
            try {
                JGR.eval("cat('Package " + string + " not found. Attempting to download...\n')");
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
            JGR.MAINRCONSOLE.execute("install.packages('" + string + "');library(" + string + ")", true);
        } else {
            try {
                JGR.eval("library(" + string + ")");
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        }
    }

    public static String[] completeCommand(String string) {
        if (!JGR.STARTED) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        string = string.replaceAll("\\.", "\\\\\\\\.");
        try {
            REXP rEXP = JGR.idleEval("try(.completeCommand(\"" + string + "\"),silent=TRUE)");
            String[] stringArray = null;
            if (rEXP != null && (stringArray = rEXP.asStrings()) != null) {
                return stringArray;
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return null;
    }

    public static String[] completeFile(String string) {
        Object object;
        string = string.replaceFirst("~", System.getProperty("user.home"));
        int n = string.length();
        int n2 = n - 1;
        int n3 = 0;
        if (n == 0) {
            n2 = 0;
        }
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            string = string.replaceAll(":/", "://");
        }
        while (n2 > 0 && string.charAt(n2) != '/') {
            --n2;
        }
        if (n2 == 0 && (n == 0 || string.charAt(n2) != '/')) {
            bl = true;
        }
        string2 = bl ? "." : (n2 == 0 ? "/" : string.substring(0, n2));
        n3 = n2;
        if (n3 < n && string.charAt(n3) == '/') {
            ++n3;
        }
        string3 = n3 < n ? string.substring(n3) : "";
        File file = null;
        String[] stringArray = null;
        file = new File(string2);
        if (file.exists()) {
            stringArray = file.list();
        }
        if (stringArray == null) {
            return null;
        }
        int n4 = 0;
        Vector<String> vector = new Vector<String>();
        Object object2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (!((String)object).startsWith(string3)) continue;
            object2 = n4 == 0 ? object : RController.commonWithPrefix((String)object2, (String)object);
            ++n4;
            if (JGRPrefs.showHiddenFiles) {
                vector.add((String)object);
                continue;
            }
            if (((String)object).trim().startsWith(".")) continue;
            vector.add((String)object);
        }
        if (object2 != null && vector.size() == 1) {
            String string4 = ((String)object2).replace('\\', '/');
            object = null;
            string4 = string2 == "." ? string4 : (string2 == "/" ? "/" + string4 : string2 + "/" + string4);
            object = new File(string4);
            if (((File)object).exists() && ((File)object).isDirectory()) {
                string4 = string4 + "/";
            }
            if (string4.endsWith("//")) {
                string4 = "";
            }
            return new String[]{string4.replaceFirst(string, "")};
        }
        if (vector.size() > 1) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public static String makeValidVariableName(String string) {
        return string.replaceAll("[ -+*/\\()=!~`@#$%^&*<>,?;:\"']", ".");
    }

    public static String makeRStringVector(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return "c()";
        }
        String string = "c(";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + "\"" + arrayList.get(i).toString() + "\"";
            if (i < arrayList.size() - 1) {
                string = string + ",";
            }
            if (i % 10 != 9) continue;
            string = string + "\n";
        }
        string = string + ")";
        return string;
    }

    public static String makeRStringVector(JList jList) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            arrayList.add(jList.getModel().getElementAt(i));
        }
        return RController.makeRStringVector(arrayList);
    }

    public static String makeRStringVector(DefaultListModel defaultListModel) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            arrayList.add(defaultListModel.getElementAt(i));
        }
        return RController.makeRStringVector(arrayList);
    }

    public static String makeRStringVector(Vector vector) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < vector.size(); ++i) {
            arrayList.add(vector.get(i));
        }
        return RController.makeRStringVector(arrayList);
    }

    public static String makeRVector(Vector vector) {
        String string = "c(";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.get(i);
            if (i < vector.size() - 1) {
                string = string + ",";
            }
            if (i % 10 != 9) continue;
            string = string + "\n";
        }
        string = string + ")";
        return string;
    }

    public static String makeRVector(DefaultListModel defaultListModel) {
        Vector vector = new Vector();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            vector.add(defaultListModel.getElementAt(i));
        }
        return RController.makeRVector(vector);
    }

    public static boolean isValidSubsetExp(String string, String string2) {
        if (string == null || string.length() < 1) {
            return false;
        }
        try {
            REXPLogical rEXPLogical = (REXPLogical)JGR.eval("(function(x,subset){result<-try(e <- substitute(subset),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nresult<-try(r <- eval(e, x, parent.frame()),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nis.logical(r)\n})(" + string2 + "," + string + ")");
            if (rEXPLogical == null) {
                return false;
            }
            if (rEXPLogical == null) {
                return false;
            }
            return rEXPLogical.isTRUE()[0];
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return false;
    }

    public static String[] getKeyWords() {
        String[] stringArray = null;
        try {
            REXP rEXP = JGR.idleEval(".refreshKeyWords()");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                return stringArray;
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return stringArray;
    }

    public static String[] getObjects() {
        String[] stringArray = null;
        try {
            REXP rEXP = JGR.idleEval(".refreshObjects()");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                return stringArray;
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return stringArray;
    }

    public static void refreshObjects() {
        String string;
        boolean bl;
        int n;
        int n2;
        REXP rEXP = null;
        try {
            String[] stringArray;
            rEXP = JGR.idleEval(".getModels()");
            if (rEXP != null && rEXP != null && !rEXP.isNull()) {
                JGR.MODELS.clear();
            }
            if (rEXP != null && !rEXP.isNull() && rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    JGR.MODELS.add(RController.createRModel(stringArray[i], stringArray[++i]));
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            String[] stringArray;
            rEXP = JGR.idleEval(".getDataObjects()");
            if (rEXP != null && !rEXP.isNull()) {
                JGR.DATA.clear();
            }
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                n2 = 1;
                for (n = 0; n < stringArray.length; ++n) {
                    bl = stringArray[n].equals("null") || stringArray[n].trim().length() == 0;
                    string = bl ? n2 + "" : stringArray[n];
                    JGR.DATA.add(RController.createRObject(string, stringArray[++n], null, !bl));
                    ++n2;
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            String[] stringArray;
            rEXP = JGR.idleEval(".getOtherObjects()");
            if (rEXP != null && !rEXP.isNull()) {
                JGR.OTHERS.clear();
            }
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                n2 = 1;
                for (n = 0; n < stringArray.length; ++n) {
                    bl = stringArray[n].equals("null") || stringArray[n].trim().length() == 0;
                    string = bl ? n2 + "" : stringArray[n];
                    JGR.OTHERS.add(RController.createRObject(string, stringArray[++n], null, !bl));
                    ++n2;
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            String[] stringArray;
            rEXP = JGR.idleEval(".getFunctionsInWS()");
            if (rEXP != null && !rEXP.isNull()) {
                JGR.FUNCTIONS.clear();
            }
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                n2 = 1;
                for (n = 0; n < stringArray.length; ++n) {
                    JGR.FUNCTIONS.add(RController.createRObject(stringArray[n], "function", null, true));
                    ++n2;
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
    }

    public static Object[][] refreshPackages() {
        Object[][] objectArray;
        block9: {
            objectArray = null;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            try {
                int n;
                String[] stringArray;
                REXP rEXP = JGR.eval("sort(.packages(all.available=T))");
                if (rEXP == null || rEXP.isNull() || rEXP.asStrings() == null) break block9;
                REXP rEXP2 = JGR.eval("(.packages())");
                if (rEXP2 != null && !rEXP2.isNull() && (stringArray = rEXP2.asStrings()) != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        hashtable.put(stringArray[n], dummy);
                    }
                }
                stringArray = rEXP.asStrings();
                objectArray = new Object[stringArray.length][4];
                for (n = 0; n < stringArray.length; ++n) {
                    objectArray[n][2] = new String(stringArray[n]);
                    try {
                        objectArray[n][3] = JGR.eval("packageDescription(\"" + stringArray[n] + "\",fields=\"Title\")").asString();
                    }
                    catch (Exception exception) {
                        objectArray[n][1] = "";
                    }
                    objectArray[n][0] = hashtable.containsKey(stringArray[n]) ? new Boolean(true) : new Boolean(false);
                    objectArray[n][1] = new Boolean(false);
                    for (int i = 0; i < JGRPackageManager.defaultPackages.length; ++i) {
                        if (!stringArray[n].equals(JGRPackageManager.defaultPackages[i]) && !JGRPackageManager.neededPackages.containsKey(stringArray[n])) continue;
                        objectArray[n][1] = new Boolean(true);
                    }
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        }
        return objectArray;
    }

    public static Vector createContent(RObject rObject, Collection collection) {
        Vector<RObject> vector = new Vector<RObject>();
        String string = "";
        if (rObject.getParent() != null && rObject.getParent().getType().equals("table")) {
            string = "," + rObject.getParent().getRName();
        }
        try {
            String[] stringArray;
            REXP rEXP = JGR.eval("suppressWarnings(try(.getContent(" + rObject.getRName() + string + "),silent=TRUE))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null && !stringArray[0].startsWith("Error")) {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    RObject rObject2;
                    boolean bl = stringArray[i].equals("null") || stringArray[i].trim().length() == 0;
                    String string2 = bl ? n + "" : stringArray[i];
                    if ((rObject2 = RController.createRObject(string2, stringArray[++i], rObject, !bl)) != null) {
                        vector.add(rObject2);
                    }
                    ++n;
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return vector;
    }

    public static RObject createRObject(String string, String string2, RObject rObject, boolean bl) {
        RObject rObject2 = new RObject(string, string2, rObject, bl);
        if (string2.equals("data.frame")) {
            try {
                REXP rEXP = JGR.eval("dim(" + rObject2.getRName() + ")");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("dim(" + rEXP.asIntegers()[0] + ":" + rEXP.asIntegers()[1] + ")");
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        } else if (string2.equals("matrix")) {
            try {
                REXP rEXP = JGR.eval("dim(" + rObject2.getRName() + ")");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("dim(" + rEXP.asIntegers()[0] + ":" + rEXP.asIntegers()[1] + ")");
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        } else if (string2.equals("factor")) {
            try {
                REXP rEXP = JGR.eval("length(levels(" + rObject2.getRName() + "))");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("levels: " + rEXP.asIntegers()[0]);
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        } else if (string2.equals("list")) {
            try {
                REXP rEXP = JGR.eval("length(" + rObject2.getRName() + ")");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("length: " + rEXP.asIntegers()[0]);
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        } else if (string2.equals("table")) {
            try {
                REXP rEXP = JGR.eval("length(dim(" + rObject2.getRName() + "))");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("dim: " + rEXP.asIntegers()[0]);
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        } else if (string2.equals("function")) {
            String string3 = RController.getFunHelp(rObject2.getRName());
            if (string3 != null) {
                rObject2.setInfo("arguments: " + string3.replaceFirst(rObject2.getRName(), "").replaceAll("<br>", ""));
            }
        } else if (rObject != null && rObject.getType().equals("table")) {
            try {
                REXP rEXP = JGR.eval("length(dimnames(" + rObject.getRName() + ")[[\"" + rObject2.getName() + "\"]])");
                if (!rEXP.isNull() && rEXP.asIntegers() != null) {
                    rObject2.setInfo("cats: " + rEXP.asIntegers()[0]);
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        }
        return rObject2;
    }

    public static RModel createRModel(String string, String string2) {
        int n;
        String string3;
        String[] stringArray;
        REXP rEXP;
        double[] dArray;
        REXP rEXP2;
        RModel rModel = new RModel(string, string2);
        try {
            rEXP2 = JGR.eval("summary(" + string + ")[[\"r.squared\"]]");
            if (!rEXP2.isNull() && (dArray = rEXP2.asDoubles()) != null) {
                rModel.setRsquared(dArray[0]);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            rEXP2 = JGR.eval("AIC(" + string + ")");
            if (!rEXP2.isNull() && (dArray = rEXP2.asDoubles()) != null) {
                rModel.setAic(dArray[0]);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            rEXP2 = JGR.eval("deviance(" + string + ")");
            if (!rEXP2.isNull() && (dArray = rEXP2.asDoubles()) != null) {
                rModel.setDeviance(dArray[0]);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            int[] nArray;
            REXP rEXP3 = JGR.eval("summary(" + string + ")[[\"df\"]]");
            if (rEXP3 != null && !rEXP3.isNull() && (nArray = rEXP3.asIntegers()) != null) {
                rModel.setDf(nArray[0]);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            rEXP = JGR.eval("family(" + string + ")[[\"family\"]]");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                rModel.setFamily(stringArray[0]);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            rEXP = JGR.eval("suppressWarnings(try(capture.output(" + string + "[[\"call\"]][[\"formula\"]])))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                string3 = "";
                for (n = 0; n < stringArray.length; ++n) {
                    string3 = string3 + stringArray[n];
                }
                rModel.setCall(string3);
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        try {
            rEXP = JGR.eval("suppressWarnings(try(capture.output(" + string + "[[\"call\"]][[\"data\"]])))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                string3 = "";
                for (n = 0; n < stringArray.length; ++n) {
                    string3 = string3 + stringArray[n];
                }
                if (!string3.trim().equals("NULL")) {
                    rModel.setData(string3);
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return rModel;
    }

    public static String getFunHelpTip(String string) {
        String string2 = RController.getFunHelp(string);
        return string2 != null ? "<html><pre>" + string2 + "</pre></html>" : null;
    }

    private static String getFunHelp(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        String[] stringArray = null;
        try {
            REXP rEXP = JGR.idleEval("try(deparse(args(" + string + ")),silent=T)");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                string2 = "";
                int n = -1;
                for (int i = 0; i < (n = stringArray.length); ++i) {
                    if (n - 2 == i && !stringArray[i].trim().equals("NULL")) {
                        string2 = string2 + stringArray[i].replaceFirst("function", string);
                        continue;
                    }
                    if (stringArray[i].trim().equals("NULL")) continue;
                    string2 = string2 + stringArray[i].replaceFirst("function", string) + "<br>";
                }
            } else {
                return null;
            }
            string2 = string2 + "";
            if (string2.trim().length() == 0) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string2.indexOf("Error") >= 0 ? null : string2;
    }

    public static String getSummary(RObject rObject) {
        if (rObject.getType().equals("function")) {
            return "<html><pre>" + RController.getFunHelp(rObject.getRName()) + "</pre></html>";
        }
        String string = "";
        String[] stringArray = null;
        try {
            int n;
            REXP rEXP = JGR.idleEval("suppressWarnings(try(capture.output(summary(" + rObject.getRName() + ")),silent=TRUE))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null && !stringArray[0].startsWith("Error")) {
                n = -1;
                for (int i = ((n = stringArray.length) > 10 ? 10 : n) - 1; i >= 0; --i) {
                    string = i < n - 1 ? stringArray[i] + "<br>" + string : stringArray[i] + "       ";
                }
            } else {
                return null;
            }
            string = "<html><pre>" + string + (n > 10 ? "..." : "") + "</pre></html>";
        }
        catch (Exception exception) {
            return null;
        }
        return string.startsWith("<html><pre>Error") ? null : string;
    }

    public static void newFunction(RObject rObject) {
        try {
            String[] stringArray;
            REXP rEXP = JGR.eval("suppressWarnings(try(capture.output(" + rObject.getRName() + "),silent=TRUE))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i == 0) {
                        stringBuffer.append(rObject.getRName() + " <- " + stringArray[i] + "\n");
                        continue;
                    }
                    stringBuffer.append(stringArray[i] + "\n");
                }
                if (stringBuffer.length() > 0) {
                    new Editor().setText(stringBuffer);
                }
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
    }

    public static SVarSet newSet(RObject rObject) {
        SVarSet sVarSet = new SVarSet();
        sVarSet.setName(rObject.getRName());
        if (rObject.getType().equals("function")) {
            try {
                String[] stringArray;
                REXP rEXP = JGR.eval("suppressWarnings(try(capture.output(" + rObject.getRName() + "),silent=TRUE))");
                if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            stringBuffer.append(rObject.getRName() + " <- " + stringArray[i] + "\n");
                            continue;
                        }
                        stringBuffer.append(stringArray[i] + "\n");
                    }
                    if (stringBuffer.length() > 0) {
                        new Editor().setText(stringBuffer);
                    }
                }
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
            return null;
        }
        try {
            SVar sVar;
            String[] stringArray;
            REXP rEXP = JGR.eval("suppressWarnings(try(attributes(" + rObject.getRName() + ")[[\"row.names\"]],silent=TRUE))");
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null && stringArray.length > 0 && !stringArray[0].startsWith("Error")) {
                sVar = RController.newVar(sVarSet, "row.names", rEXP.asStrings());
                sVarSet.add(sVar);
            }
            if (!(sVar = RController.createContent(rObject, null).iterator()).hasNext()) {
                sVarSet.add(RController.createSVar(sVarSet, rObject));
            }
            while (sVar.hasNext()) {
                RObject rObject2 = (RObject)sVar.next();
                sVarSet.add(RController.createSVar(sVarSet, rObject2));
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return sVarSet;
    }

    private static SVar createSVar(SVarSet sVarSet, RObject rObject) {
        SVar sVar = null;
        try {
            REXP rEXP = JGR.eval("suppressWarnings(try(" + rObject.getRName() + ",silent=TRUE))");
            if (rEXP == null || rEXP.isNull()) {
                return null;
            }
            if (rObject.getType().equals("factor")) {
                REXP rEXP2 = JGR.eval("suppressWarnings(try(levels(" + rObject.getRName() + "),silent=TRUE))");
                REXP rEXP3 = JGR.eval("suppressWarnings(try(as.integer(" + rObject.getRName() + "),silent=TRUE))");
                if (rEXP3 != null && !rEXP3.isNull() && rEXP != null && !rEXP.isNull() && rEXP2.asStrings() != null && rEXP3.asIntegers() != null) {
                    int[] nArray = new int[rEXP3.asIntegers().length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = rEXP3.asIntegers()[i];
                    }
                    sVar = RController.newVar(sVarSet, rObject.getName(), nArray, rEXP2.asStrings());
                }
            } else if (rObject.getType().equals("character")) {
                if (rEXP != null && !rEXP.isNull() && rEXP.isString()) {
                    sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asStrings());
                }
            } else if (rEXP != null && !rEXP.isNull() && rEXP.isInteger()) {
                sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asIntegers());
            } else if (rEXP != null && !rEXP.isNull() && rEXP.isNumeric()) {
                sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asDoubles());
            }
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
        return sVar;
    }

    public static SVar newVar(SVarSet sVarSet, String string, double[] object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: double[" + ((double[])object).length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != ((double[])object).length) {
            object2 = new double[sVarSet.at(0).size()];
            for (int i = 0; i < ((double[])object).length && i < ((SVarDouble)object2).length; ++i) {
                object2[i] = (SVarDouble)object[i];
            }
            object = object2;
        }
        object2 = new SVarDouble(string, object);
        return object2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, int[] object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + ((int[])object).length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != ((int[])object).length) {
            object2 = new int[sVarSet.at(0).size()];
            for (int i = 0; i < ((int[])object).length && i < ((SVarInt)object2).length; ++i) {
                object2[i] = (SVarInt)object[i];
            }
            object = object2;
        }
        object2 = new SVarInt(string, object);
        return object2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, String[] stringArray) {
        int n;
        String[] stringArray2;
        if (stringArray == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: String[]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != stringArray.length) {
            stringArray2 = new String[sVarSet.at(0).size()];
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray = stringArray2;
        }
        stringArray2 = new SVarObj(string);
        n = 0;
        while (n < stringArray.length) {
            stringArray2.add((Object)stringArray[n++]);
        }
        return stringArray2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, int[] nArray, String[] stringArray) {
        if (nArray == null) {
            return null;
        }
        if (stringArray == null) {
            return RController.newVar(sVarSet, string, nArray);
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + nArray.length + "] + levels[" + stringArray.length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != nArray.length) {
            int[] nArray2 = new int[sVarSet.at(0).size()];
            for (int i = 0; i < stringArray.length && i < nArray2.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray = nArray2;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        SVarFact sVarFact = new SVarFact(string, nArray, stringArray);
        return sVarFact;
    }

    public static boolean export(SVarSet sVarSet, String string) {
        boolean bl = false;
        if (string == null || string.equals("data.frame")) {
            bl = RController.exportDataFrame(sVarSet);
        } else if (string != null && string.equals("matrix")) {
            bl = RController.exportMatrix(sVarSet);
        } else if (string != null && string.equals("list")) {
            bl = RController.exportList(sVarSet);
        } else if (string != null && string.equals("numeric")) {
            bl = RController.exportNumeric(sVarSet);
        } else if (string != null && string.equals("integer")) {
            bl = RController.exportInteger(sVarSet);
        } else if (string != null && string.equals("character")) {
            bl = RController.exportCharacter(sVarSet);
        } else if (string != null && string.equals("factor")) {
            bl = RController.exportFactor(sVarSet);
        }
        return bl;
    }

    private static boolean exportNumeric(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            if (sVarSet.at(0) instanceof SVarInt) {
                return RController.exportInteger(sVarSet);
            }
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, ((SVarDouble)sVarSet.at((int)0)).cont);
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean exportInteger(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, ((SVarInt)sVarSet.at((int)0)).cont);
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean exportFactor(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            int[] nArray = new int[((SVarFact)sVarSet.at((int)0)).cont.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((SVarFact)sVarSet.at((int)0)).cont[i] + 1;
            }
            REXPFactor rEXPFactor = new REXPFactor(nArray, ((SVarFact)sVarSet.at((int)0)).cats);
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, rEXPFactor);
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean exportCharacter(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, ((SVarObj)sVarSet.at(0)).getContent());
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean setVariableName(String string) throws REngineException, REXPMismatchException {
        JGR.eval(string + " <- " + TEMP_VARIABLE_NAME + "; rm(" + TEMP_VARIABLE_NAME + ")");
        return true;
    }

    private static boolean exportDataFrame(SVarSet sVarSet) {
        try {
            String[] stringArray;
            int n;
            boolean bl = false;
            String[] stringArray2 = new String[sVarSet.length()];
            SVar sVar = null;
            int n2 = 0;
            for (int i = 0; i < sVarSet.count(); ++i) {
                if (!sVarSet.at(i).getName().equals("row.names")) continue;
                n = stringArray2.length;
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray = ((SVarObj)sVarSet.at(i)).at(j);
                    if (stringArray != null) {
                        stringArray2[j] = stringArray.toString();
                        continue;
                    }
                    stringArray2[j] = n - 1 + "";
                    ++n;
                }
                bl = true;
                n2 = i;
                sVar = sVarSet.at(i);
                sVarSet.remove(i);
                break;
            }
            RList rList = new RList();
            for (n = 0; n < sVarSet.count(); ++n) {
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    REXPDouble rEXPDouble = new REXPDouble(((SVarDouble)sVarSet.at((int)n)).cont);
                    rList.put(sVarSet.at(n).getName(), rEXPDouble);
                    continue;
                }
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    REXPInteger rEXPInteger = new REXPInteger(((SVarInt)sVarSet.at((int)n)).cont);
                    rList.put(sVarSet.at(n).getName(), rEXPInteger);
                    continue;
                }
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    int[] nArray = new int[((SVarFact)sVarSet.at((int)n)).cont.length];
                    stringArray = ((SVarFact)sVarSet.at((int)n)).cats;
                    boolean bl2 = false;
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = ((SVarFact)sVarSet.at((int)n)).cont[i] + 1;
                        if (nArray[i] != 0) continue;
                        bl2 = true;
                        nArray[i] = stringArray.length + 1;
                    }
                    if (bl2) {
                        String[] stringArray3 = new String[stringArray.length + 1];
                        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                        stringArray3[stringArray3.length - 1] = "NA";
                        stringArray = stringArray3;
                        bl2 = false;
                    }
                    REXPFactor rEXPFactor = new REXPFactor(nArray, stringArray);
                    rList.put(sVarSet.at(n).getName(), rEXPFactor);
                    continue;
                }
                if (!sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                REXPString rEXPString = new REXPString(((SVarObj)sVarSet.at(n)).getContent());
                rList.put(sVarSet.at(n).getName(), rEXPString);
            }
            if (!bl) {
                for (n = 1; n <= stringArray2.length; ++n) {
                    stringArray2[n - 1] = n + "";
                }
            }
            if (bl) {
                sVarSet.insert(n2, sVar);
            }
            REXPString rEXPString = new REXPString(stringArray2);
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, RController.createDataFrame(rList, rEXPString));
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    public static REXP createDataFrame(RList rList, REXP rEXP) throws REXPMismatchException {
        if (rList == null || rList.size() < 1) {
            throw new REXPMismatchException(new REXPList(rList), "data frame (must have dim>0)");
        }
        if (!(rList.at(0) instanceof REXPVector)) {
            throw new REXPMismatchException(new REXPList(rList), "data frame (contents must be vectors)");
        }
        return new REXPGenericVector(rList, new REXPList(new RList(new REXP[]{new REXPString("data.frame"), new REXPString(rList.keys()), rEXP}, new String[]{"class", "names", "row.names"})));
    }

    private static boolean exportMatrix(SVarSet sVarSet) {
        try {
            Object[] objectArray;
            String[] stringArray = new String[sVarSet.count()];
            int n = sVarSet.at(0).size();
            boolean bl = false;
            boolean bl2 = false;
            if (sVarSet.at(0).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                objectArray = new double[sVarSet.count() * n];
                bl2 = true;
            } else if (sVarSet.at(0).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                objectArray = new int[sVarSet.count() * n];
                bl = true;
            } else if (sVarSet.at(0).getClass().getName().equals("org.rosuda.ibase.SVarObj")) {
                objectArray = new String[sVarSet.count() * n];
            } else {
                return false;
            }
            for (int i = 0; i < sVarSet.count(); ++i) {
                stringArray[i] = sVarSet.at(i).getName();
                if (bl) {
                    System.arraycopy(((SVarInt)sVarSet.at((int)i)).cont, 0, objectArray, i * n, n);
                    continue;
                }
                if (bl2) {
                    System.arraycopy(((SVarDouble)sVarSet.at((int)i)).cont, 0, objectArray, i * n, n);
                    continue;
                }
                System.arraycopy(((SVarObj)sVarSet.at(i)).getContent(), 0, objectArray, i * n, n);
            }
            REXPVector rEXPVector = bl ? new REXPInteger((int[])objectArray) : (bl2 ? new REXPDouble((double[])objectArray) : new REXPString((String[])objectArray));
            JGR.getREngine().assign(TEMP_MATRIX_CONTENT_JGR, rEXPVector);
            String[] stringArray2 = new String[sVarSet.length()];
            for (int i = 1; i <= stringArray2.length; ++i) {
                stringArray2[i - 1] = i + "";
            }
            REXPList rEXPList = new REXPList(new RList(new REXP[]{new REXPString(stringArray2), new REXPString(stringArray)}));
            JGR.getREngine().assign(TEMP_MATRIX_DIM_NAMES_JGR, rEXPList);
            JGR.eval(sVarSet.getName() + " <- matrix(tempMatrixContentJGR,dimnames=tempMatrixDimNamesJGR,nrow=" + stringArray2.length + ",ncol=" + stringArray.length + ")");
            JGR.eval("rm(tempMatrixContentJGR);rm(tempMatrixDimNamesJGR)");
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean exportList(SVarSet sVarSet) {
        try {
            RList rList = new RList();
            for (int i = 0; i < sVarSet.count(); ++i) {
                Object object;
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    object = new REXPDouble(((SVarDouble)sVarSet.at((int)i)).cont);
                    rList.put(sVarSet.at(i).getName(), object);
                    continue;
                }
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    object = new REXPInteger(((SVarInt)sVarSet.at((int)i)).cont);
                    rList.put(sVarSet.at(i).getName(), object);
                    continue;
                }
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    object = new int[((SVarFact)sVarSet.at((int)i)).cont.length];
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        object[j] = ((SVarFact)sVarSet.at((int)i)).cont[j] + 1;
                    }
                    REXPFactor rEXPFactor = new REXPFactor((int[])object, ((SVarFact)sVarSet.at((int)i)).cats);
                    rList.put(sVarSet.at(i).getName(), rEXPFactor);
                    continue;
                }
                if (!sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                object = new REXPString(((SVarObj)sVarSet.at(i)).getContent());
                rList.put(sVarSet.at(i).getName(), object);
            }
            REXPList rEXPList = new REXPList(rList);
            JGR.getREngine().assign(TEMP_VARIABLE_NAME, rEXPList);
            RController.setVariableName(sVarSet.getName());
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    public static String commonWithPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < n && (string4 = string.substring(i, i + 1)).equals(string2.substring(i, i + 1)); ++i) {
            string3 = string3 + string4;
        }
        return string3;
    }
}

