% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_export.R
\name{export_xlsx.mQR_matrix}
\alias{export_xlsx.mQR_matrix}
\title{Exporting mQR_matrix objects in Excel files}
\usage{
\method{export_xlsx}{mQR_matrix}(
  x,
  export_dir = "./",
  layout_file = c("ByComponent", "ByQRMatrix"),
  file_extension = c(".xls", ".xlsx"),
  layout = c("all", "modalities", "values", "combined"),
  ...
)
}
\arguments{
\item{x}{a \code{\link{mQR_matrix}} object to export.}

\item{export_dir}{export directory.}

\item{layout_file}{export parameter. By default, (\code{layout_file = "ByComponent"}) and an Excel file is exported for each part of the
quality report matrix (modalities and values matrices). To group both modalities and values reports/sheets into a single Excel file, use the option \code{layout_file = "ByQRMatrix"}.}

\item{file_extension}{possible values are \code{".xls"} and \code{".xlsx"}.}

\item{layout}{elements of the report to export: see \code{\link{export_xlsx.QR_matrix}} .}

\item{...}{other parameters of the function \code{\link{export_xlsx.QR_matrix}}.}
}
\value{
Returns invisibly (via \code{invisible(x)}) the same \code{\link{mQR_matrix}} object as \code{x}.
}
\description{
To export several quality reports in Excel files
}
\seealso{
\link[=fr-export_xlsx.mQR_matrix]{Traduction française}

Other QR_matrix functions: 
\code{\link{export_xlsx}()},
\code{\link{export_xlsx.QR_matrix}()},
\code{\link{extract_QR}()},
\code{\link{rbind.QR_matrix}()},
\code{\link{sort}()},
\code{\link{weighted_score}()}
}
\concept{QR_matrix functions}
