% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_issues.R,
%   R/wrangling_dataset_labels.R, R/wrangling_dataset_milestones.R
\name{write_issues_to_dataset}
\alias{write_issues_to_dataset}
\alias{write_issues_to_dataset.IssuesTB}
\alias{write_issues_to_dataset.default}
\alias{write_labels_to_dataset}
\alias{write_milestones_to_dataset}
\title{Save datasets in a yaml file}
\usage{
write_issues_to_dataset(issues, ...)

\method{write_issues_to_dataset}{IssuesTB}(
  issues,
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "list_issues.yaml",
  verbose = TRUE,
  ...
)

\method{write_issues_to_dataset}{default}(issues, ...)

write_labels_to_dataset(
  labels,
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "list_labels.yaml",
  verbose = TRUE
)

write_milestones_to_dataset(
  milestones,
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "list_milestones.yaml",
  verbose = TRUE
)
}
\arguments{
\item{issues}{a \code{IssuesTB} object.}

\item{\dots}{Unused parameter.}

\item{dataset_dir}{A character string specifying the path which contains the
datasets (only taken into account if \code{source} is set to \code{"local"}).
Defaults to the package option \code{IssueTrackeR.dataset.dir}.}

\item{dataset_name}{A character string specifying the name of the datasets
which will be written (only taken into account if \code{source} is set to
\code{"local"}).
Defaults to \code{"open_issues.yaml"}.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}

\item{labels}{a list representing all labels with simpler structure (with
name, description, colour)}

\item{milestones}{a list representing milestones with simpler structure (with
title, description and due_on).}
}
\value{
invisibly (with \code{invisible()}) \code{TRUE} if the export was
successful and an error otherwise.
}
\description{
Save datasets in a yaml file
}
\details{
Depending on the object, the defaults value of the argument
\code{dataset_name} is:

\itemize{
\item \code{"list_issues.yaml"} for issues;
\item \code{"list_labels.yaml"} for labels;
\item \code{"list_milestones.yaml"} for milestones.
}
}
\examples{
path <- system.file("data_issues", package = "IssueTrackeR")
issues <- get_issues(
    source = "local",
    dataset_dir = path,
    dataset_name = "list_issues.yaml"
)
milestones <- get_milestones(
    source = "local",
    dataset_dir = path,
    dataset_name = "list_milestones.yaml"
)
labels <- get_labels(
    source = "local",
    dataset_dir = path,
    dataset_name = "list_labels.yaml"
)

write_issues_to_dataset(issues)
write_labels_to_dataset(labels)
write_milestones_to_dataset(milestones)

}
