% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{saveFile}
\alias{saveFile}
\title{Saves a report with important statistics to describe the sample.}
\usage{
saveFile(fileName, results)
}
\arguments{
\item{fileName}{the name  of the file with the path where the CSV file will be saved.}

\item{results}{is the vector obtained from running the rescaling process over all the variables of interest.}
}
\description{
\code{saveFile} Saves a csv report with the following columns: Convex Hull Area, Convex Hull Centroid X, Convex Hull Centroid Y, Sample Size, Ichen, Iscaled, pvalue , Mean, MeanScaled, STD DEV, SDScaled, Q_{1\%}, Q_{1\%Scaled}, $Q_{99\%}, Q_{99\%Scaled}, Max, Max_{Scaled}, Min, Min_{Scaled}, Skew,Skew_Scaled, Kutorsis,Kutorsis_Scaled.
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data <- loadFile(fileInput)
scaledI<-rescaleI(data,1000)
fn = file.path(tempdir(),"output.csv",fsep = .Platform$file.sep)
saveFile(fn,scaledI)
if (file.exists(fn)){
    file.remove(fn)
}
}
