% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{detached_sorted_nonempty}
\alias{detached_sorted_nonempty}
\title{Check intervals are detached, sorted and non-empty.}
\usage{
detached_sorted_nonempty(x)
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points.}
}
\value{
Boolean value.
}
\description{
Check that \code{x} is an integer matrix specifying intervals, that the specified intervals are detached (i.e. non-overlapping/disjoint and non-touching) and that it is sorted (given that the intervals are detached, sorting by start position gives a unique result), and that the start points are greater than the end points (i.e. that they are non-empty/the lengths of all intervals is greater than zero).
}
\examples{
detached_sorted_nonempty(cbind(1:2, 2:3)) 
detached_sorted_nonempty(cbind(c(1, 3), c(2, 4))) 
detached_sorted_nonempty(cbind(1, 1)) 
}
