% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadProbbase.R
\name{download.SCI}
\alias{download.SCI}
\title{Update the Symptom-Cause-Information source (aka probbaseV5).}
\usage{
download.SCI()
}
\value{
\item{newProbbase}{The Symptom-Cause-Information ("Probbase") used to assign causes of death.}
}
\description{
The function downloads the most recent version of InterVA5, extracts
the probbase.xls file (i.e., the Symptom-Cause-Information [SCI] source ), 
and returns SCI as a matrix.
}
\examples{

\dontrun{
data(RandomVA5)
RandomVA5 <- RandomVA5[1:2, ]
newProbbase <- download.SCI()
out <- InterVA5(RandomVA5, sci = newProbbase, HIV = "h", Malaria = "l", write=FALSE, 
    directory = tempdir(), filename = "VA5_result", output = "extended", append = FALSE)
}

}
\seealso{
\code{\link{probbaseV5}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
