% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreImputedData.R
\name{ScoreImpute}
\alias{ScoreImpute}
\title{Perform risk score multiple imputation method}
\usage{
ScoreImpute(data, event.model, censor.model = event.model, col.control,
  NN.control = NN.options(), time.dep = NULL, m, bootstrap.strata = rep(1,
  nrow(data)), ..., parallel = c("no", "multicore", "snow")[1], ncpus = 1L,
  cl = NULL)
}
\arguments{
\item{data}{The data set for which imputation is required}

\item{event.model}{The right hand side of the formula to be used for fitting the Cox model for calculating the time to 
event score e.g. ~Z1+Z2+Z3.}

\item{censor.model}{The right hand side of the formula to be used for fitting the Cox model for calculating the time to 
censoring score if not included then \code{event.model} will be used}

\item{col.control}{A list of the columns names of \code{data} which are used by the imputation algorithm
See example below and for further details of these columns and their purpose see \code{\link{col.headings}}}

\item{NN.control}{Parameters which control the nearest neighbour algorithm. See \code{\link{NN.options}}}

\item{time.dep}{A ScoreTD object, to be included if the time dependent score imputation method is to be used, otherwise it should be NULL}

\item{m}{The number of data sets to impute}

\item{bootstrap.strata}{When performing the bootstrap procedure for fitting the models,
how should the data be stratified (see strata argument to \code{boot::boot}). if argument
is not used then standard sampling with replacement is used to generate the bootstrap data}

\item{...}{Additional arguments passed into the Cox model Note the subset and na.action arguments should not be used 
(na.fail will be used when fitting the Cox model)}

\item{parallel}{The type of parallel operation to be used (if any).}

\item{ncpus}{integer: number of processes to be used in parallel operation: typically one would chose this to be
the number of available CPUs}

\item{cl}{An optional parallel or snow cluster for use if \code{parallel="snow"}. If not supplied, a
cluster on the local machine is created for the duration of the call.}
}
\value{
A \code{ScoreImputedSet} object
}
\description{
Perform risk score multiple imputation method
}
\details{
Note that coxph may fail to converge and the following output
Warning in fitter(X, Y, strats, offset, init, control, weights = weights, :  
Ran out of iterations and did not converge

It is possible to use ridge regression by including a ridge term in the model formula
(e.g. \code{~Z1+ridge(Z2,theta=1)}). See \code{\link[survival]{ridge}} for further details
}
\examples{

data(ScoreInd)

col.control <- col.headings(has.event="event", time="time",
                            Id="Id",arm="arm",
                            DCO.time="DCO.time", 
                            to.impute="to.impute")

\dontrun{
ans <- ScoreImpute(data=ScoreInd,event.model=~Z1+Z2+Z3+Z4+Z5,
                   col.control=col.control, m=5,
                   bootstrap.strata=ScoreInd$arm,
                   NN.control=NN.options(NN=5,w.censoring = 0.2))
}

}
\seealso{
\code{\link{ScoreImputedSet.object}}
}

