% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_weighting.R
\name{pca_weighting}
\alias{pca_weighting}
\title{Function that weight the quantitative variable by PCA method}
\usage{
pca_weighting(data)
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative
variables}
}
\value{
It returns a dataframe with rows = observations and column =
composite indicator
}
\description{
The pca_weighting function is designed to perform a principal component
analysis (PCA) on the input data to calculate weights that correct for
overlapping information between related indicators. This process makes it
possible to create a composite indicator that captures as much information
as possible from individual indicators while reducing the dimensionality of
the data
}
\examples{

data("Education")
Indicator_pca=pca_weighting(Education)
print(Indicator_pca)
}
\references{
OECD/European Union/EC-JRC (2008), Handbook on Constructing
Composite Indicators: Methodology and User Guide, OECD Publishing, Paris,
<https://doi.org/10.1787/9789264043466-en>
}
\keyword{PCA}
\keyword{indicator}
\keyword{weighting}
