% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateIncidence.R
\name{estimateIncidence}
\alias{estimateIncidence}
\title{Collect population incidence estimates}
\usage{
estimateIncidence(
  cdm,
  denominatorTable,
  outcomeTable,
  censorTable = NULL,
  denominatorCohortId = NULL,
  outcomeCohortId = NULL,
  censorCohortId = NULL,
  interval = "years",
  completeDatabaseIntervals = TRUE,
  outcomeWashout = Inf,
  repeatedEvents = FALSE,
  strata = list(),
  includeOverallStrata = TRUE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{denominatorTable}{A cohort table with a set of denominator cohorts
(for example, created using the \code{generateDenominatorCohortSet()}
function).}

\item{outcomeTable}{A cohort table in the cdm reference containing
a set of outcome cohorts.}

\item{censorTable}{A cohort table in the cdm reference containing a cohort
to be used for censoring. Individuals will stop contributing time at risk
from the date of their first record in the censor cohort. If they appear in
the censor cohort before entering the denominator cohort they will be
excluded. The censor cohort can only contain one record per individual.}

\item{denominatorCohortId}{The cohort definition ids or the cohort names of
the denominator cohorts of interest. If NULL all cohorts will be considered
in the analysis.}

\item{outcomeCohortId}{The cohort definition ids or the cohort names of the
outcome cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{censorCohortId}{The cohort definition id or the cohort name of the
cohort to be used for censoring. Must be specified if there are multiple
cohorts in the censor table.}

\item{interval}{Time intervals over which incidence is estimated. Can
be "weeks", "months", "quarters", "years", or "overall". ISO weeks will
be used for weeks. Calendar months, quarters, or years can be used, or an
overall estimate for the entire time period observed (from earliest cohort
start to last cohort end) can also be estimated. If more than one option is
chosen then results will be estimated for each chosen interval.}

\item{completeDatabaseIntervals}{TRUE/ FALSE. Where TRUE, incidence will
only be estimated for those intervals where the denominator cohort
captures all the interval.}

\item{outcomeWashout}{The number of days used for a 'washout' period
between the end of one outcome and an individual starting to contribute
time at risk. If Inf, no time can be contributed after an event has
occurred.}

\item{repeatedEvents}{TRUE/ FALSE. If TRUE, an individual will be able to
contribute multiple events during the study period (time while they are
present in an outcome cohort and any subsequent washout will be
excluded). If FALSE, an individual will only contribute time up to their
first event.}

\item{strata}{Variables added to the denominator cohort table for which to
stratify estimates.}

\item{includeOverallStrata}{Whether to include an overall result as well as
strata specific results (when strata has been specified).}
}
\value{
Incidence estimates
}
\description{
Collect population incidence estimates
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
}
}
