% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{availableIncidenceGrouping}
\alias{availableIncidenceGrouping}
\title{Variables that can be used for faceting and colouring incidence plots}
\usage{
availableIncidenceGrouping(result, varying = FALSE)
}
\arguments{
\item{result}{Incidence results}

\item{varying}{If FALSE, only variables with non-unique values will be
returned, otherwise all available variables will be returned}
}
\description{
Variables that can be used for faceting and colouring incidence plots
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2014-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
availableIncidenceGrouping(inc)
}
}
