/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Test;

public abstract class IntMatrix1DTest
extends TestCase {
    protected IntMatrix1D A;
    protected IntMatrix1D B;
    protected int SIZE = 170;
    protected Random rand = new Random(0L);

    public IntMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, (int)Math.max(1L, (long)this.rand.nextInt() % this.A.size()));
        }
        for (n = 0; n < (int)this.B.size(); ++n) {
            this.B.setQuick(n, (int)Math.max(1L, (long)this.rand.nextInt() % this.A.size()));
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateIntIntFunctionIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < (int)this.A.size(); ++n) {
            int n3 = this.A.getQuick(n);
            n2 += n3 * n3;
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square);
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntIntFunctionIntFunctionIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        for (n2 = 0; n2 < (int)this.A.size(); ++n2) {
            intArrayList.add(n2);
        }
        n2 = 0;
        for (n = 0; n < (int)this.A.size(); ++n) {
            int n3 = this.A.getQuick(n);
            n2 += n3 * n3;
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square, intArrayList);
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntMatrix2DIntIntFunctionIntIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < (int)this.A.size(); ++n) {
            int n3 = this.A.getQuick(n);
            int n4 = this.B.getQuick(n);
            n2 += n3 * n4;
        }
        n = this.A.aggregate(this.B, IntFunctions.plus, IntFunctions.mult);
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testAssignInt() {
        int n = this.rand.nextInt();
        this.A.assign(n);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)n, (int)this.A.getQuick(i));
        }
    }

    public void testAssignIntArray() {
        int n;
        int[] nArray = new int[(int)this.A.size()];
        for (n = 0; n < (int)this.A.size(); ++n) {
            nArray[n] = this.rand.nextInt();
        }
        this.A.assign(nArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            IntMatrix1DTest.assertEquals((int)nArray[n], (int)this.A.getQuick(n));
        }
    }

    public void testAssignIntFunction() {
        IntMatrix1D intMatrix1D = this.A.copy();
        this.A.assign(IntFunctions.neg);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            int n = -intMatrix1D.getQuick(i);
            IntMatrix1DTest.assertEquals((int)n, (int)this.A.getQuick(i));
        }
    }

    public void testAssignIntMatrix1D() {
        this.A.assign(this.B);
        IntMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)this.B.getQuick(i), (int)this.A.getQuick(i));
        }
    }

    public void testAssignIntMatrix1DIntIntFunction() {
        IntMatrix1D intMatrix1D = this.A.copy();
        this.A.assign(this.B, IntFunctions.plus);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)(intMatrix1D.getQuick(i) + this.B.getQuick(i)), (int)this.A.getQuick(i));
        }
    }

    public void testAssignIntProcedureInt() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix1D intMatrix1D = this.A.copy();
        this.A.assign(intProcedure, -1);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(intMatrix1D.getQuick(i)) > 1) {
                IntMatrix1DTest.assertEquals((int)-1, (int)this.A.getQuick(i));
                continue;
            }
            IntMatrix1DTest.assertEquals((int)intMatrix1D.getQuick(i), (int)this.A.getQuick(i));
        }
    }

    public void testAssignIntProcedureIntFunction() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix1D intMatrix1D = this.A.copy();
        this.A.assign(intProcedure, IntFunctions.neg);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(intMatrix1D.getQuick(i)) > 1) {
                IntMatrix1DTest.assertEquals((int)(-intMatrix1D.getQuick(i)), (int)this.A.getQuick(i));
                continue;
            }
            IntMatrix1DTest.assertEquals((int)intMatrix1D.getQuick(i), (int)this.A.getQuick(i));
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        int n3 = 0;
        while ((long)n3 < this.A.size()) {
            if (this.A.getQuick(n3) != 0) {
                ++n2;
            }
            ++n3;
        }
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsInt() {
        int n = 1;
        this.A.assign(n);
        boolean bl = this.A.equals(n);
        IntMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2);
        IntMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        IntMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        IntMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0);
        this.A.setQuick((int)this.A.size() / 3, 7);
        this.A.setQuick((int)this.A.size() / 2, 1);
        int[] nArray = this.A.getMaxLocation();
        IntMatrix1DTest.assertEquals((int)7, (int)nArray[0]);
        IntMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)nArray[1]);
    }

    public void testMinLocation() {
        this.A.assign(0);
        this.A.setQuick((int)this.A.size() / 3, -7);
        this.A.setQuick((int)this.A.size() / 2, -1);
        int[] nArray = this.A.getMinLocation();
        IntMatrix1DTest.assertEquals((int)-7, (int)nArray[0]);
        IntMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)nArray[1]);
    }

    public void testGetNegativeValuesIntArrayListIntArrayList() {
        this.A.assign(0);
        this.A.setQuick((int)this.A.size() / 3, -7);
        this.A.setQuick((int)this.A.size() / 2, -1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2);
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(-7));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(-1));
    }

    public void testGetNonZerosIntArrayListIntArrayList() {
        this.A.assign(0);
        this.A.setQuick((int)this.A.size() / 3, 7);
        this.A.setQuick((int)this.A.size() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2);
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(7));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(1));
    }

    public void testGetPositiveValuesIntArrayListIntArrayList() {
        this.A.assign(0);
        this.A.setQuick((int)this.A.size() / 3, 7);
        this.A.setQuick((int)this.A.size() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2);
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix1DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        IntMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(7));
        IntMatrix1DTest.assertTrue((boolean)intArrayList2.contains(1));
    }

    public void testToArray() {
        int[] nArray = this.A.toArray();
        IntMatrix1DTest.assertTrue(((int)this.A.size() == nArray.length ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)nArray[i], (int)this.A.getQuick(i));
        }
    }

    public void testToArrayIntArray() {
        int[] nArray = new int[(int)this.A.size()];
        this.A.toArray(nArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)this.A.getQuick(i), (int)nArray[i]);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        IntMatrix2D intMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                IntMatrix1DTest.assertEquals((int)this.A.getQuick(n3++), (int)intMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        IntMatrix3D intMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    IntMatrix1DTest.assertEquals((int)this.A.getQuick(n4++), (int)intMatrix3D.getQuick(i, k, j));
                }
            }
        }
    }

    public void testSwap() {
        IntMatrix1D intMatrix1D = this.A.copy();
        IntMatrix1D intMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)intMatrix1D2.getQuick(i), (int)this.A.getQuick(i));
            IntMatrix1DTest.assertEquals((int)intMatrix1D.getQuick(i), (int)this.B.getQuick(i));
        }
    }

    public void testViewFlip() {
        IntMatrix1D intMatrix1D = this.A.viewFlip();
        IntMatrix1DTest.assertEquals((long)((int)this.A.size()), (long)intMatrix1D.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            IntMatrix1DTest.assertEquals((int)this.A.getQuick(i), (int)intMatrix1D.getQuick((int)this.A.size() - 1 - i));
        }
    }

    public void testViewPart() {
        IntMatrix1D intMatrix1D = this.A.viewPart(15, 11);
        for (int i = 0; i < 11; ++i) {
            IntMatrix1DTest.assertEquals((int)this.A.getQuick(15 + i), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewSelectionIntProcedure() {
        IntMatrix1D intMatrix1D = this.A.viewSelection(new IntProcedure(){

            public boolean apply(int n) {
                return n % 2 == 0;
            }
        });
        int n = 0;
        while ((long)n < intMatrix1D.size()) {
            int n2 = intMatrix1D.getQuick(n);
            if (n2 % 2 != 0) {
                IntMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{5, 11, 22, 37, 101};
        IntMatrix1D intMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            IntMatrix1DTest.assertEquals((int)this.A.getQuick(nArray[i]), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewSorted() {
        IntMatrix1D intMatrix1D = this.A.viewSorted();
        for (int i = 0; i < (int)this.A.size() - 1; ++i) {
            IntMatrix1DTest.assertTrue((intMatrix1D.getQuick(i + 1) >= intMatrix1D.getQuick(i) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        IntMatrix1D intMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < intMatrix1D.size()) {
            IntMatrix1DTest.assertEquals((int)this.A.getQuick(n2 * n), (int)intMatrix1D.getQuick(n2));
            ++n2;
        }
    }

    public void testZDotProductIntMatrix1D() {
        int n = this.A.zDotProduct(this.B);
        int n2 = 0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            n2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testZDotProductIntMatrix1DIntInt() {
        int n = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        int n2 = 0;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            n2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    @Test
    public void testZDotProductIntMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        this.B.getNonZeros(intArrayList, intArrayList2);
        int n = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        int n2 = 0;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            n2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testZSum() {
        int n = this.A.zSum();
        int n2 = 0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            n2 += this.A.getQuick(i);
        }
        IntMatrix1DTest.assertEquals((int)n2, (int)n);
    }
}

