/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCG
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D z;
    private DoubleMatrix1D q;
    private DoubleMatrix1D r;

    public DoubleCG(DoubleMatrix1D doubleMatrix1D) {
        this.p = doubleMatrix1D.copy();
        this.z = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            this.M.apply(this.r, this.z);
            d3 = this.r.zDotProduct(this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
            } else {
                d2 = d3 / d4;
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(d2));
            }
            doubleMatrix2D.zMult(this.p, this.q);
            d = d3 / this.p.zDotProduct(this.q);
            doubleMatrix1D2.assign(this.p, DoubleFunctions.plusMultSecond(d));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-d));
            d4 = d3;
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

