/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.csparsej.tdouble.Dcs_add;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_cumsum;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dropzeros;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dupl;
import edu.emory.mathcs.csparsej.tdouble.Dcs_multiply;
import edu.emory.mathcs.csparsej.tdouble.Dcs_transpose;
import edu.emory.mathcs.csparsej.tdouble.Dcs_util;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Dcs_common.Dcs dcs;
    protected boolean rowIndexesSorted;

    public SparseCCDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray[0].length);
        this.assign(dArray);
    }

    public SparseCCDoubleMatrix2D(Dcs_common.Dcs dcs) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(dcs.m, dcs.n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.dcs = dcs;
    }

    public SparseCCDoubleMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCDoubleMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.dcs = Dcs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
    }

    public SparseCCDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double d, boolean bl, boolean bl2) {
        block9: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n3 = Math.max(nArray.length, 1);
        this.dcs = Dcs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
        int[] nArray3 = new int[n2];
        int[] nArray4 = this.dcs.p;
        int[] nArray5 = this.dcs.i;
        double[] dArray = this.dcs.x;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray2[i];
            nArray3[n4] = nArray3[n4] + 1;
        }
        Dcs_cumsum.cs_cumsum((int[])nArray4, (int[])nArray3, (int)n2);
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray2[i];
            nArray3[n5] = nArray3[n5] + 1;
            nArray5[i] = nArray[i];
            if (dArray == null) continue;
            dArray[i] = d;
        }
        if (bl && !Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (bl2) {
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            if (this.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public SparseCCDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        block10: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block10;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n3 = Math.max(nArray.length, 1);
        this.dcs = Dcs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
        int[] nArray3 = new int[n2];
        int[] nArray4 = this.dcs.p;
        int[] nArray5 = this.dcs.i;
        double[] dArray2 = this.dcs.x;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray2[i];
            nArray3[n4] = nArray3[n4] + 1;
        }
        Dcs_cumsum.cs_cumsum((int[])nArray4, (int[])nArray3, (int)n2);
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray2[i];
            nArray3[n5] = nArray3[n5] + 1;
            nArray5[i] = nArray[i];
            if (dArray2 == null) continue;
            dArray2[i] = dArray[i];
        }
        if (bl2) {
            Dcs_dropzeros.cs_dropzeros((Dcs_common.Dcs)this.dcs);
        }
        if (bl && !Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (bl3) {
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            if (this.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            double[] dArray = this.dcs.x;
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] * d;
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    return doubleFunction.apply(d);
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(double d) {
        if (d == 0.0) {
            Arrays.fill(this.dcs.i, 0);
            Arrays.fill(this.dcs.p, 0);
            Arrays.fill(this.dcs.x, 0.0);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.dcs.x[i] = d;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = (SparseCCDoubleMatrix2D)doubleMatrix2D;
            System.arraycopy(sparseCCDoubleMatrix2D.getColumnPointers(), 0, this.dcs.p, 0, this.columns + 1);
            int n = sparseCCDoubleMatrix2D.getRowIndexes().length;
            if (this.dcs.nzmax < n) {
                this.dcs.i = new int[n];
                this.dcs.x = new double[n];
            }
            System.arraycopy(sparseCCDoubleMatrix2D.getRowIndexes(), 0, this.dcs.i, 0, n);
            System.arraycopy(sparseCCDoubleMatrix2D.getValues(), 0, this.dcs.x, 0, n);
            this.rowIndexesSorted = sparseCCDoubleMatrix2D.rowIndexesSorted;
        } else if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D) {
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = ((SparseRCDoubleMatrix2D)doubleMatrix2D).getTranspose();
            this.dcs.p = sparseRCDoubleMatrix2D.getRowPointers();
            this.dcs.i = sparseRCDoubleMatrix2D.getColumnIndexes();
            this.dcs.x = sparseRCDoubleMatrix2D.getValues();
            this.dcs.nzmax = this.dcs.x.length;
            this.rowIndexesSorted = true;
        } else {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    SparseCCDoubleMatrix2D.this.setQuick(n, n2, d);
                    return d;
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof SparseCCDoubleMatrix2D && doubleDoubleFunction == DoubleFunctions.plus) {
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = (SparseCCDoubleMatrix2D)doubleMatrix2D;
            this.dcs = Dcs_add.cs_add((Dcs_common.Dcs)this.dcs, (Dcs_common.Dcs)sparseCCDoubleMatrix2D.dcs, (double)1.0, (double)1.0);
            return this;
        }
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseCCDoubleMatrix2D.this.setQuick(n, n2, SparseCCDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
            final double d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this.assign(doubleMatrix2D);
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseCCDoubleMatrix2D.this.setQuick(n, n2, d * SparseCCDoubleMatrix2D.this.getQuick(n, n2) + d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            int[] nArray = this.dcs.i;
            int[] nArray2 = this.dcs.p;
            double[] dArray = this.dcs.x;
            int n = this.columns;
            while (--n >= 0) {
                int n2 = nArray2[n];
                int n3 = nArray2[n + 1];
                while (--n3 >= n2) {
                    int n4 = nArray[n3];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] * doubleMatrix2D.getQuick(n4, n);
                    if (dArray[n3] != 0.0) continue;
                    this.remove(n4, n);
                }
            }
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.div) {
            int[] nArray = this.dcs.i;
            int[] nArray3 = this.dcs.p;
            double[] dArray = this.dcs.x;
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray3[n];
                int n7 = nArray3[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = n7;
                    dArray[n9] = dArray[n9] / doubleMatrix2D.getQuick(n8, n);
                    if (dArray[n7] != 0.0) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public int cardinality() {
        return this.dcs.p[this.columns];
    }

    public Dcs_common.Dcs elements() {
        return this.dcs;
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        int[] nArray = this.dcs.i;
        int[] nArray2 = this.dcs.p;
        double[] dArray = this.dcs.x;
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                double d;
                int n4 = nArray[n3];
                double d2 = dArray[n3];
                dArray[n3] = d = intIntDoubleFunction.apply(n4, n, d2);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.dcs.p;
    }

    public DenseDoubleMatrix2D getDense() {
        final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                denseDoubleMatrix2D.setQuick(n, n2, SparseCCDoubleMatrix2D.this.getQuick(n, n2));
                return d;
            }
        });
        return denseDoubleMatrix2D;
    }

    public synchronized double getQuick(int n, int n2) {
        int n3 = SparseCCDoubleMatrix2D.searchFromTo(this.dcs.i, n, this.dcs.p[n2], this.dcs.p[n2 + 1] - 1);
        double d = 0.0;
        if (n3 >= 0) {
            d = this.dcs.x[n3];
        }
        return d;
    }

    public SparseRCDoubleMatrix2D getRowCompressed() {
        Dcs_common.Dcs dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = new SparseRCDoubleMatrix2D(this.rows, this.columns);
        sparseRCDoubleMatrix2D.columnIndexes = dcs.i;
        sparseRCDoubleMatrix2D.rowPointers = dcs.p;
        sparseRCDoubleMatrix2D.values = dcs.x;
        sparseRCDoubleMatrix2D.columnIndexesSorted = true;
        return sparseRCDoubleMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.dcs.i;
    }

    public SparseCCDoubleMatrix2D getTranspose() {
        Dcs_common.Dcs dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = new SparseCCDoubleMatrix2D(this.columns, this.rows);
        sparseCCDoubleMatrix2D.dcs = dcs;
        return sparseCCDoubleMatrix2D;
    }

    public double[] getValues() {
        return this.dcs.x;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseCCDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, double d) {
        int n3 = SparseCCDoubleMatrix2D.searchFromTo(this.dcs.i, n, this.dcs.p[n2], this.dcs.p[n2 + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0) {
                this.remove(n2, n3);
            } else {
                this.dcs.x[n3] = d;
            }
            return;
        }
        if (d != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d);
        }
    }

    public void sortRowIndexes() {
        this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        if (this.dcs == null) {
            throw new IllegalArgumentException("Exception occured in cs_transpose()!");
        }
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        if (!Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
    }

    public void removeZeroes() {
        Dcs_dropzeros.cs_dropzeros((Dcs_common.Dcs)this.dcs);
    }

    public void trimToSize() {
        Dcs_util.cs_sprealloc((Dcs_common.Dcs)this.dcs, (int)0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.dcs.p[i + 1];
            for (int j = this.dcs.p[i]; j < n; ++j) {
                stringBuilder.append('(').append(this.dcs.i[j]).append(',').append(i).append(')').append('\t').append(this.dcs.x[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = doubleMatrix1D2 == null || bl;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if ((long)n2 != doubleMatrix1D.size() || (long)n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)denseDoubleMatrix1D.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)denseDoubleMatrix1D2.index(0);
        final int[] nArray = this.dcs.i;
        final int[] nArray2 = this.dcs.p;
        final double[] dArray3 = this.dcs.x;
        int n7 = n4;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!bl2 && d2 / d != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d2 / d));
            }
            if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n9;
                int n10;
                n8 = 2;
                Future[] futureArray = new Future[n8];
                final double[] dArray4 = new double[n];
                int n11 = this.columns / n8;
                for (n10 = 0; n10 < n8; ++n10) {
                    n9 = n10 * n11;
                    final int n12 = n10 == n8 - 1 ? this.columns : n9 + n11;
                    final int n13 = n10;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n13 == 0) {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    double d = dArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n2 = nArray[j];
                                        int n32 = n4 + n3 * n2;
                                        dArray[n32] = dArray[n32] + dArray3[j] * d;
                                    }
                                }
                            } else {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    double d = dArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = nArray[j];
                                        dArray4[n52] = dArray4[n52] + dArray3[j] * d;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n9 = n10 = n % 10; n9 < n; n9 += 10) {
                    int n14 = n4 + n9 * n3;
                    dArray[n14] = dArray[n14] + dArray4[n9];
                    int n15 = n4 + (n9 + 1) * n3;
                    dArray[n15] = dArray[n15] + dArray4[n9 + 1];
                    int n16 = n4 + (n9 + 2) * n3;
                    dArray[n16] = dArray[n16] + dArray4[n9 + 2];
                    int n17 = n4 + (n9 + 3) * n3;
                    dArray[n17] = dArray[n17] + dArray4[n9 + 3];
                    int n18 = n4 + (n9 + 4) * n3;
                    dArray[n18] = dArray[n18] + dArray4[n9 + 4];
                    int n19 = n4 + (n9 + 5) * n3;
                    dArray[n19] = dArray[n19] + dArray4[n9 + 5];
                    int n20 = n4 + (n9 + 6) * n3;
                    dArray[n20] = dArray[n20] + dArray4[n9 + 6];
                    int n21 = n4 + (n9 + 7) * n3;
                    dArray[n21] = dArray[n21] + dArray4[n9 + 7];
                    int n22 = n4 + (n9 + 8) * n3;
                    dArray[n22] = dArray[n22] + dArray4[n9 + 8];
                    int n23 = n4 + (n9 + 9) * n3;
                    dArray[n23] = dArray[n23] + dArray4[n9 + 9];
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    int n24 = n4 + n9 * n3;
                    dArray[n24] = dArray[n24] + dArray4[n9];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n25 = nArray2[i + 1];
                    double d3 = dArray2[n6 + n5 * i];
                    for (int j = nArray2[i]; j < n25; ++j) {
                        int n26 = nArray[j];
                        int n27 = n4 + n3 * n26;
                        dArray[n27] = dArray[n27] + dArray3[j] * d3;
                    }
                }
            }
            if (d != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d));
            }
        } else if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n28 = this.columns / n8;
            for (int i = 0; i < n8; ++i) {
                final int n29 = i * n28;
                final int n30 = i == n8 - 1 ? this.columns : n29 + n28;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n29 * n3;
                        int n2 = SparseCCDoubleMatrix2D.this.dcs.p[n29];
                        for (int i = n29; i < n30; ++i) {
                            double d3 = 0.0;
                            int n32 = SparseCCDoubleMatrix2D.this.dcs.p[i + 1];
                            while (n2 + 10 < n32) {
                                int n42 = n2 + 9;
                                d3 += dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]] + dArray3[n42] * dArray2[n6 + n5 * SparseCCDoubleMatrix2D.this.dcs.i[n42--]];
                                n2 += 10;
                            }
                            while (n2 < n32) {
                                d3 += dArray3[n2] * dArray2[SparseCCDoubleMatrix2D.this.dcs.i[n2]];
                                ++n2;
                            }
                            dArray[n] = d * d3 + d2 * dArray[n];
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n31 = this.dcs.p[0];
            for (int i = 0; i < this.columns; ++i) {
                double d4 = 0.0;
                int n32 = this.dcs.p[i + 1];
                while (n31 + 10 < n32) {
                    int n33 = n31 + 9;
                    d4 += dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]] + dArray3[n33] * dArray2[n6 + n5 * this.dcs.i[n33--]];
                    n31 += 10;
                }
                while (n31 < n32) {
                    d4 += dArray3[n31] * dArray2[this.dcs.i[n31]];
                    ++n31;
                }
                dArray[n7] = d * d4 + d2 * dArray[n7];
                n7 += n3;
            }
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.rows();
        int n4 = doubleMatrix2D.columns();
        if (bl2) {
            n3 = doubleMatrix2D.columns();
            n4 = doubleMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = doubleMatrix2D instanceof SparseCCDoubleMatrix2D ? new SparseCCDoubleMatrix2D(n, n5, n * n5) : new DenseDoubleMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && d2 != 1.0) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D && doubleMatrix2D2 instanceof DenseDoubleMatrix2D) {
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = bl ? this.getTranspose() : this;
            DenseDoubleMatrix2D denseDoubleMatrix2D = bl2 ? (DenseDoubleMatrix2D)doubleMatrix2D.viewDice() : (DenseDoubleMatrix2D)doubleMatrix2D;
            DenseDoubleMatrix2D denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)doubleMatrix2D2;
            int[] nArray = sparseCCDoubleMatrix2D.dcs.p;
            int[] nArray2 = sparseCCDoubleMatrix2D.dcs.i;
            double[] dArray = sparseCCDoubleMatrix2D.dcs.x;
            int n6 = (int)denseDoubleMatrix2D.index(0, 0);
            int n7 = denseDoubleMatrix2D.rowStride();
            int n8 = denseDoubleMatrix2D.columnStride();
            double[] dArray2 = denseDoubleMatrix2D.elements;
            int n9 = (int)denseDoubleMatrix2D2.index(0, 0);
            int n10 = denseDoubleMatrix2D2.rowStride();
            int n11 = denseDoubleMatrix2D2.columnStride();
            double[] dArray3 = denseDoubleMatrix2D2.elements;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n12 = nArray[j + 1];
                    double d3 = dArray2[n6 + j * n7 + i * n8];
                    for (int k = nArray[j]; k < n12; ++k) {
                        int n13 = nArray2[k];
                        int n14 = n9 + n13 * n10 + i * n11;
                        dArray3[n14] = dArray3[n14] + dArray[k] * d3;
                    }
                }
            }
            if (d != 1.0) {
                doubleMatrix2D2.assign(DoubleFunctions.mult(d));
            }
        } else if (doubleMatrix2D instanceof SparseCCDoubleMatrix2D && doubleMatrix2D2 instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = bl ? this.getTranspose() : this;
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D2 = (SparseCCDoubleMatrix2D)doubleMatrix2D;
            if (bl2) {
                sparseCCDoubleMatrix2D2 = sparseCCDoubleMatrix2D2.getTranspose();
            }
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D3 = (SparseCCDoubleMatrix2D)doubleMatrix2D2;
            sparseCCDoubleMatrix2D3.dcs = Dcs_multiply.cs_multiply((Dcs_common.Dcs)sparseCCDoubleMatrix2D.dcs, (Dcs_common.Dcs)sparseCCDoubleMatrix2D2.dcs);
            if (sparseCCDoubleMatrix2D3.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_multiply()");
            }
            if (d != 1.0) {
                sparseCCDoubleMatrix2D3.assign(DoubleFunctions.mult(d));
            }
        } else {
            if (bl2) {
                doubleMatrix2D = doubleMatrix2D.viewDice();
            }
            DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
            int n15 = n2;
            while (--n15 >= 0) {
                doubleMatrix1DArray[n15] = doubleMatrix2D.viewRow(n15);
            }
            DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
            int n16 = n;
            while (--n16 >= 0) {
                doubleMatrix1DArray2[n16] = doubleMatrix2D2.viewRow(n16);
            }
            DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
            int[] nArray = this.dcs.i;
            int[] nArray3 = this.dcs.p;
            double[] dArray = this.dcs.x;
            int n17 = this.columns;
            while (--n17 >= 0) {
                int n18 = nArray3[n17];
                int n19 = nArray3[n17 + 1];
                while (--n19 >= n18) {
                    int n20 = nArray[n19];
                    doublePlusMultSecond.multiplicator = dArray[n19] * d;
                    if (!bl) {
                        doubleMatrix1DArray2[n20].assign(doubleMatrix1DArray[n17], doublePlusMultSecond);
                        continue;
                    }
                    doubleMatrix1DArray2[n17].assign(doubleMatrix1DArray[n20], doublePlusMultSecond);
                }
            }
        }
        return doubleMatrix2D2;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, double d) {
        IntArrayList intArrayList = new IntArrayList(this.dcs.i);
        intArrayList.setSizeRaw(this.dcs.p[this.columns]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.dcs.x);
        doubleArrayList.setSizeRaw(this.dcs.p[this.columns]);
        intArrayList.beforeInsert(n3, n);
        doubleArrayList.beforeInsert(n3, d);
        int n4 = this.dcs.p.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.dcs.p[n5] = this.dcs.p[n5] + 1;
        }
        this.dcs.i = intArrayList.elements();
        this.dcs.x = doubleArrayList.elements();
        this.dcs.nzmax = intArrayList.elements().length;
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.dcs.i);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.dcs.x);
        intArrayList.remove(n2);
        doubleArrayList.remove(n2);
        int n3 = this.dcs.p.length;
        while (--n3 > n) {
            int n4 = n3;
            this.dcs.p[n4] = this.dcs.p[n4] - 1;
        }
        this.dcs.i = intArrayList.elements();
        this.dcs.x = doubleArrayList.elements();
        this.dcs.nzmax = intArrayList.elements().length;
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }
}

