/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FComplexFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FComplexFactory1D dense = new FComplexFactory1D();
    public static final FComplexFactory1D sparse = new FComplexFactory1D();

    protected FComplexFactory1D() {
    }

    public FComplexMatrix1D append(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2) {
        FComplexMatrix1D fComplexMatrix1D3 = this.make((int)(fComplexMatrix1D.size() + fComplexMatrix1D2.size()));
        fComplexMatrix1D3.viewPart(0, (int)fComplexMatrix1D.size()).assign(fComplexMatrix1D);
        fComplexMatrix1D3.viewPart((int)fComplexMatrix1D.size(), (int)fComplexMatrix1D2.size()).assign(fComplexMatrix1D2);
        return fComplexMatrix1D3;
    }

    public FComplexMatrix1D make(float[] fArray) {
        if (this == sparse) {
            return new SparseFComplexMatrix1D(fArray);
        }
        return new DenseFComplexMatrix1D(fArray);
    }

    public FComplexMatrix1D make(FComplexMatrix1D[] fComplexMatrix1DArray) {
        if (fComplexMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < fComplexMatrix1DArray.length; ++i) {
            n = (int)((long)n + fComplexMatrix1DArray[i].size());
        }
        FComplexMatrix1D fComplexMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < fComplexMatrix1DArray.length; ++i) {
            fComplexMatrix1D.viewPart(n, (int)fComplexMatrix1DArray[i].size()).assign(fComplexMatrix1DArray[i]);
            n = (int)((long)n + fComplexMatrix1DArray[i].size());
        }
        return fComplexMatrix1D;
    }

    public FComplexMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseFComplexMatrix1D(n);
        }
        return new DenseFComplexMatrix1D(n);
    }

    public FComplexMatrix1D make(int n, float[] fArray) {
        return this.make(n).assign(fArray);
    }

    public FComplexMatrix1D make(ArrayList<float[]> arrayList) {
        int n = arrayList.size();
        FComplexMatrix1D fComplexMatrix1D = this.make(n);
        for (int i = 0; i < n; ++i) {
            fComplexMatrix1D.setQuick(i, arrayList.get(i));
        }
        return fComplexMatrix1D;
    }

    public FComplexMatrix1D random(int n) {
        return this.make(n).assign(FComplexFunctions.random());
    }

    public FComplexMatrix1D repeat(FComplexMatrix1D fComplexMatrix1D, int n) {
        int n2 = (int)fComplexMatrix1D.size();
        FComplexMatrix1D fComplexMatrix1D2 = this.make(n * n2);
        for (int i = 0; i < n; ++i) {
            fComplexMatrix1D2.viewPart(n2 * i, n2).assign(fComplexMatrix1D);
        }
        return fComplexMatrix1D2;
    }

    public FComplexMatrix1D sample(int n, float[] fArray, float f) {
        float f2 = 1.0E-5f;
        if (f < 0.0f - f2 || f > 1.0f + f2) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        FComplexMatrix1D fComplexMatrix1D = this.make(n);
        int n2 = Math.round((float)n * f);
        if (n2 == 0) {
            return fComplexMatrix1D;
        }
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(n2, n, new FloatMersenneTwister());
        for (int i = 0; i < n; ++i) {
            if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
            fComplexMatrix1D.setQuick(i, fArray);
        }
        return fComplexMatrix1D;
    }

    public ArrayList<float[]> toList(FComplexMatrix1D fComplexMatrix1D) {
        int n = (int)fComplexMatrix1D.size();
        ArrayList<float[]> arrayList = new ArrayList<float[]>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.set(i, fComplexMatrix1D.getQuick(i));
        }
        return arrayList;
    }
}

