/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalDoubleMatrix2D(double[][] dArray, int n) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, n);
        this.assign(dArray);
    }

    public DiagonalDoubleMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new double[this.dlength];
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            int n = this.dlength;
            while (--n >= 0) {
                int n2 = n;
                this.elements[n2] = this.elements[n2] * d;
            }
        } else {
            int n = this.dlength;
            while (--n >= 0) {
                this.elements[n] = doubleFunction.apply(this.elements[n]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(double d) {
        int n = this.dlength;
        while (--n >= 0) {
            this.elements[n] = d;
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " dlength=" + this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalDoubleMatrix2D.this.elements[i] = dArray[i];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.dlength;
            while (--n5 >= 0) {
                this.elements[n5] = dArray[n5];
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(double[][] dArray) {
        int n;
        int n2;
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (dArray[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray[n2].length + "columns()=" + this.columns());
            }
            this.elements[i] = dArray[n2++][n++];
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof DiagonalDoubleMatrix2D) {
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D = (DiagonalDoubleMatrix2D)doubleMatrix2D;
            if (this.dindex != diagonalDoubleMatrix2D.dindex || this.dlength != diagonalDoubleMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalDoubleMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalDoubleMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(doubleMatrix2D);
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof DiagonalDoubleMatrix2D) {
            double d;
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D = (DiagonalDoubleMatrix2D)doubleMatrix2D;
            if (this.dindex != diagonalDoubleMatrix2D.dindex || this.dlength != diagonalDoubleMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalDoubleMatrix2D with different diagonal stored.");
            }
            if (doubleDoubleFunction instanceof DoublePlusMultSecond && (d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator) == 0.0) {
                return this;
            }
            final double[] dArray = diagonalDoubleMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.dlength);
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                                double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                                if (d == 1.0) {
                                    for (int i = n3; i < n4; ++i) {
                                        int n = i;
                                        DiagonalDoubleMatrix2D.this.elements[n] = DiagonalDoubleMatrix2D.this.elements[n] + dArray[i];
                                    }
                                } else {
                                    for (int i = n3; i < n4; ++i) {
                                        DiagonalDoubleMatrix2D.this.elements[i] = DiagonalDoubleMatrix2D.this.elements[i] + d * dArray[i];
                                    }
                                }
                            } else if (doubleDoubleFunction == DoubleFunctions.mult) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalDoubleMatrix2D.this.elements[i] = DiagonalDoubleMatrix2D.this.elements[i] * dArray[i];
                                }
                            } else if (doubleDoubleFunction == DoubleFunctions.div) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalDoubleMatrix2D.this.elements[i] = DiagonalDoubleMatrix2D.this.elements[i] / dArray[i];
                                }
                            } else {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalDoubleMatrix2D.this.elements[i] = doubleDoubleFunction.apply(DiagonalDoubleMatrix2D.this.elements[i], dArray[i]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                double d2 = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                if (d2 == 1.0) {
                    int n5 = this.dlength;
                    while (--n5 >= 0) {
                        int n6 = n5;
                        this.elements[n6] = this.elements[n6] + dArray[n5];
                    }
                } else {
                    int n7 = this.dlength;
                    while (--n7 >= 0) {
                        this.elements[n7] = this.elements[n7] + d2 * dArray[n7];
                    }
                }
            } else if (doubleDoubleFunction == DoubleFunctions.mult) {
                int n8 = this.dlength;
                while (--n8 >= 0) {
                    this.elements[n8] = this.elements[n8] * dArray[n8];
                }
            } else if (doubleDoubleFunction == DoubleFunctions.div) {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    this.elements[n9] = this.elements[n9] / dArray[n9];
                }
            } else {
                int n10 = this.dlength;
                while (--n10 >= 0) {
                    this.elements[n10] = doubleDoubleFunction.apply(this.elements[n10], dArray[n10]);
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalDoubleMatrix2D.this.elements[i] == 0.0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[i] == 0.0) continue;
                ++n;
            }
        }
        return n;
    }

    public double[] elements() {
        return this.elements;
    }

    public boolean equals(double d) {
        double d2 = DoubleProperty.DEFAULT.tolerance();
        for (int i = 0; i < this.dlength; ++i) {
            double d3 = this.elements[i];
            double d4 = Math.abs(d - d3);
            if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                d4 = 0.0;
            }
            if (d4 <= d2) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalDoubleMatrix2D) {
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D = (DiagonalDoubleMatrix2D)object;
            double d = DoubleProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalDoubleMatrix2D.columns() || n != diagonalDoubleMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalDoubleMatrix2D.dindex || this.dlength != diagonalDoubleMatrix2D.dlength) {
                return false;
            }
            double[] dArray = diagonalDoubleMatrix2D.elements;
            for (int i = 0; i < this.dlength; ++i) {
                double d2 = dArray[i];
                double d3 = this.elements[i];
                double d4 = Math.abs(d2 - d3);
                if (d4 != d4 && (d2 != d2 && d3 != d3 || d2 == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            double d = this.elements[n];
            if (d == 0.0) continue;
            this.elements[n] = intIntDoubleFunction.apply(n, n, d);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public double[] getMaxLocation() {
        int n;
        int n2;
        int n3 = 0;
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.dlength);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n7;
                        double d = DiagonalDoubleMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            double d2 = DiagonalDoubleMatrix2D.this.elements[i];
                            if (!(d < d2)) continue;
                            d = d2;
                            n = i;
                        }
                        return new double[]{d, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n3 = (int)dArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d < dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n3 = (int)dArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                double d2 = this.elements[i];
                if (!(d < d2)) continue;
                d = d2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new double[]{d, n2, n};
    }

    public double[] getMinLocation() {
        int n;
        int n2;
        int n3 = 0;
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.dlength);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n7;
                        double d = DiagonalDoubleMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            double d2 = DiagonalDoubleMatrix2D.this.elements[i];
                            if (!(d > d2)) continue;
                            d = d2;
                            n = i;
                        }
                        return new double[]{d, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n3 = (int)dArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d > dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n3 = (int)dArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                double d2 = this.elements[i];
                if (!(d > d2)) continue;
                d = d2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new double[]{d, n2, n};
    }

    public double getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return 0.0;
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return this.elements[n];
            }
            return 0.0;
        }
        if (n < -this.dindex) {
            return 0.0;
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return this.elements[n2];
        }
        return 0.0;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public void setQuick(int n, int n2, double d) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[n] = d;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[n2] = d;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(this.isNoView && doubleMatrix1D instanceof DenseDoubleMatrix1D && doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if ((long)n2 != doubleMatrix1D.size() || (long)n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        if (!bl2 && d2 != 1.0) {
            doubleMatrix1D2.assign(DoubleFunctions.mult(d2));
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        double[] dArray = denseDoubleMatrix1D.elements;
        int n3 = denseDoubleMatrix1D.stride();
        int n4 = (int)doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        double[] dArray2 = denseDoubleMatrix1D2.elements;
        int n5 = denseDoubleMatrix1D2.stride();
        int n6 = (int)doubleMatrix1D.index(0);
        if (dArray2 == null || dArray == null) {
            throw new InternalError();
        }
        if (!bl) {
            if (this.dindex >= 0) {
                int n7 = this.dlength;
                while (--n7 >= 0) {
                    int n8 = n4 + n3 * n7;
                    dArray[n8] = dArray[n8] + d * this.elements[n7] * dArray2[this.dindex + n6 + n5 * n7];
                }
            } else {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    int n10 = -this.dindex + n4 + n3 * n9;
                    dArray[n10] = dArray[n10] + d * this.elements[n9] * dArray2[n6 + n5 * n9];
                }
            }
        } else if (this.dindex >= 0) {
            int n11 = this.dlength;
            while (--n11 >= 0) {
                int n12 = this.dindex + n4 + n3 * n11;
                dArray[n12] = dArray[n12] + d * this.elements[n11] * dArray2[n6 + n5 * n11];
            }
        } else {
            int n13 = this.dlength;
            while (--n13 >= 0) {
                int n14 = n4 + n3 * n13;
                dArray[n14] = dArray[n14] + d * this.elements[n13] * dArray2[-this.dindex + n6 + n5 * n13];
            }
        }
        return doubleMatrix1D2;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }
}

