/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.Transpose;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseColumnDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netlib.blas.BLAS;

public class DenseColumnDoubleMatrix2D
extends DoubleMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    protected double[] elements;

    public DenseColumnDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public DenseColumnDoubleMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 1, n);
        this.elements = new double[n * n2];
    }

    public DenseColumnDoubleMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.isNoView = !bl;
    }

    public DenseColumnDoubleMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            double[] dArray;
            int[] nArray;
            int[] nArray2;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new double[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray2 = new int[n2];
                nArray = new int[n2];
                dArray = new double[n2];
                matrixVectorReader.readCoordinate(nArray, nArray2, dArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray[n], nArray2[n], dArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.setQuick(nArray2[n], nArray[n], dArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] == nArray2[n]) continue;
                this.setQuick(nArray2[n], nArray[n], -dArray[n]);
            }
        }
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                d = doubleDoubleFunction.apply(d, doubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n42 * DenseColumnDoubleMatrix2D.this.rowStride + n3]));
                            }
                            n6 = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements[n9 * this.rowStride + n8]));
                }
                n6 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleProcedure doubleProcedure) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = DenseColumnDoubleMatrix2D.this.elements[n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        double d2 = 0.0;
                        if (doubleProcedure.apply(d)) {
                            d2 = doubleFunction.apply(d);
                        }
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                d = DenseColumnDoubleMatrix2D.this.elements[n42 * DenseColumnDoubleMatrix2D.this.rowStride + n3];
                                if (!doubleProcedure.apply(d)) continue;
                                d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                            }
                            n6 = 0;
                        }
                        return d2;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            double d2 = this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (doubleProcedure.apply(d2)) {
                d = doubleFunction.apply(d2);
            }
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    d2 = this.elements[n9 * this.rowStride + n8];
                    if (!doubleProcedure.apply(d2)) continue;
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                }
                n6 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = n2 - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n + nArray[n5 - 1] * DenseColumnDoubleMatrix2D.this.rowStride + nArray2[n5 - 1] * DenseColumnDoubleMatrix2D.this.columnStride]);
                        int n2 = n5 - 1;
                        while (--n2 >= n6) {
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n + nArray[n2] * DenseColumnDoubleMatrix2D.this.rowStride + nArray2[n2] * DenseColumnDoubleMatrix2D.this.columnStride]));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n + nArray[n2 - 1] * this.rowStride + nArray2[n2 - 1] * this.columnStride]);
            int n7 = n2 - 1;
            while (--n7 >= 0) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements[n + nArray[n7] * this.rowStride + nArray2[n7] * this.columnStride]));
            }
        }
        return d;
    }

    public double aggregate(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        if (!(doubleMatrix2D instanceof DenseColumnDoubleMatrix2D)) {
            return super.aggregate(doubleMatrix2D, doubleDoubleFunction, doubleDoubleFunction2);
        }
        this.checkShape(doubleMatrix2D);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)doubleMatrix2D.index(0, 0);
        final int n3 = doubleMatrix2D.rowStride();
        final int n4 = doubleMatrix2D.columnStride();
        final double[] dArray = (double[])doubleMatrix2D.elements();
        double d = 0.0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleDoubleFunction2.apply(DenseColumnDoubleMatrix2D.this.elements[n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride], dArray[n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * n3 + (n7 - 1) * n4]);
                        int n6 = 1;
                        int n22 = n7;
                        while (--n22 >= n8) {
                            int n32 = n + n22 * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n42 = n2 + n22 * n4;
                            int n5 = DenseColumnDoubleMatrix2D.this.rows - n6;
                            while (--n5 >= 0) {
                                d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DenseColumnDoubleMatrix2D.this.elements[n5 * DenseColumnDoubleMatrix2D.this.rowStride + n32], dArray[n5 * n3 + n42]));
                            }
                            n6 = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            int n9 = 1;
            d = doubleDoubleFunction2.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], dArray[n2 + (this.rows - 1) * n3 + (this.columns - 1) * n4]);
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n + n10 * this.columnStride;
                int n12 = n2 + n10 * n4;
                int n13 = this.rows - n9;
                while (--n13 >= 0) {
                    d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.elements[n13 * this.rowStride + n11], dArray[n13 * n3 + n12]));
                }
                n9 = 0;
            }
        }
        return d;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        if (doubleFunction instanceof DoubleMult) {
                            double d = ((DoubleMult)doubleFunction).multiplicator;
                            int n2 = n4;
                            while (--n2 >= n5) {
                                int n3 = n9;
                                int n42 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n42 >= 0) {
                                    int n52 = n3;
                                    DenseColumnDoubleMatrix2D.this.elements[n52] = DenseColumnDoubleMatrix2D.this.elements[n52] * d;
                                    n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        } else {
                            int n6 = n4;
                            while (--n6 >= n5) {
                                int n7 = n9;
                                int n8 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n8 >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[n7] = doubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n7]);
                                    n7 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (doubleFunction instanceof DoubleMult) {
                double d = ((DoubleMult)doubleFunction).multiplicator;
                int n7 = this.columns;
                while (--n7 >= 0) {
                    int n8 = n6;
                    int n9 = this.rows;
                    while (--n9 >= 0) {
                        int n10 = n8;
                        this.elements[n10] = this.elements[n10] * d;
                        n8 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            } else {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n6;
                    int n13 = this.rows;
                    while (--n13 >= 0) {
                        this.elements[n12] = doubleFunction.apply(this.elements[n12]);
                        n12 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                double d = DenseColumnDoubleMatrix2D.this.elements[n3];
                                if (doubleProcedure.apply(d)) {
                                    DenseColumnDoubleMatrix2D.this.elements[n3] = doubleFunction.apply(d);
                                }
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    double d = this.elements[n8];
                    if (doubleProcedure.apply(d)) {
                        this.elements[n8] = doubleFunction.apply(d);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final double d) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                double d2 = DenseColumnDoubleMatrix2D.this.elements[n3];
                                if (doubleProcedure.apply(d2)) {
                                    DenseColumnDoubleMatrix2D.this.elements[n3] = d;
                                }
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    double d2 = this.elements[n8];
                    if (doubleProcedure.apply(d2)) {
                        this.elements[n8] = d;
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double d) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[n3] = d;
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    this.elements[n8] = d;
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] dArray) {
        if ((long)dArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = this.columns - i * n3;
                    final int n5 = i == n - 1 ? 0 : n4 - n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n22 = DenseColumnDoubleMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnDoubleMatrix2D.this.rows;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n;
                                int n52 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[n42] = dArray[n22--];
                                    n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                n -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n7 = dArray.length - 1;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        this.elements[n9] = dArray[n7--];
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "columns()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (n4 - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (DenseColumnDoubleMatrix2D.this.columns - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            double[] dArray2 = dArray[n22];
                            if (dArray2.length != DenseColumnDoubleMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + dArray2.length + "columns()=" + DenseColumnDoubleMatrix2D.this.columns());
                            }
                            int n3 = n;
                            int n42 = DenseColumnDoubleMatrix2D.this.columns;
                            while (--n42 >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[n3] = dArray2[n42];
                                n3 -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                            n -= DenseColumnDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.rows;
            while (--n7 >= 0) {
                double[] dArray2 = dArray[n7];
                if (dArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + dArray2.length + "columns()=" + this.columns());
                }
                int n8 = n6;
                int n9 = this.columns;
                while (--n9 >= 0) {
                    this.elements[n8] = dArray2[n9];
                    n8 -= this.columnStride;
                }
                n6 -= this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (!(doubleMatrix2D instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(doubleMatrix2D);
            return this;
        }
        DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = (DenseColumnDoubleMatrix2D)doubleMatrix2D;
        if (denseColumnDoubleMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnDoubleMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnDoubleMatrix2D.isNoView) {
            System.arraycopy(denseColumnDoubleMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnDoubleMatrix2D)) {
            DoubleMatrix2D doubleMatrix2D2 = denseColumnDoubleMatrix2D.copy();
            if (!(doubleMatrix2D2 instanceof DenseColumnDoubleMatrix2D)) {
                super.assign(denseColumnDoubleMatrix2D);
                return this;
            }
            denseColumnDoubleMatrix2D = (DenseColumnDoubleMatrix2D)doubleMatrix2D2;
        }
        final int n2 = (int)denseColumnDoubleMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnDoubleMatrix2D.columnStride;
        final int n5 = denseColumnDoubleMatrix2D.rowStride;
        final double[] dArray = denseColumnDoubleMatrix2D.elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * n5 + (n7 - 1) * n4;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n52 = n22;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[n42] = dArray[n52];
                                n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                n52 -= n5;
                            }
                            n -= DenseColumnDoubleMatrix2D.this.columnStride;
                            n22 -= n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = dArray[n13];
                    n12 -= this.rowStride;
                    n13 -= n5;
                }
                n9 -= this.columnStride;
                n10 -= n4;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction) {
        double d;
        if (doubleDoubleFunction instanceof DoublePlusMultSecond && (d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator) == 0.0) {
            return this;
        }
        if (doubleDoubleFunction instanceof DoublePlusMultFirst && (d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator) == 0.0) {
            return this.assign(doubleMatrix2D);
        }
        if (!(doubleMatrix2D instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(doubleMatrix2D, doubleDoubleFunction);
            return this;
        }
        DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = (DenseColumnDoubleMatrix2D)doubleMatrix2D;
        this.checkShape(doubleMatrix2D);
        final double[] dArray = denseColumnDoubleMatrix2D.elements;
        final int n = (int)denseColumnDoubleMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseColumnDoubleMatrix2D.columnStride;
        final int n4 = denseColumnDoubleMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n45 = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n210 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * n4 + (n7 - 1) * n3;
                        if (doubleDoubleFunction == DoubleFunctions.mult) {
                            int n310 = n7;
                            while (--n310 >= n8) {
                                int n46 = n45;
                                int n5 = n210;
                                int n6 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n6 >= 0) {
                                    int n72 = n46;
                                    DenseColumnDoubleMatrix2D.this.elements[n72] = DenseColumnDoubleMatrix2D.this.elements[n72] * dArray[n5];
                                    n46 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    n5 -= n4;
                                }
                                n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (doubleDoubleFunction == DoubleFunctions.div) {
                            int n82 = n7;
                            while (--n82 >= n8) {
                                int n9 = n45;
                                int n10 = n210;
                                int n11 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n11 >= 0) {
                                    int n12 = n9;
                                    DenseColumnDoubleMatrix2D.this.elements[n12] = DenseColumnDoubleMatrix2D.this.elements[n12] / dArray[n10];
                                    n9 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    n10 -= n4;
                                }
                                n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                            double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                            if (d == 1.0) {
                                int n13 = n7;
                                while (--n13 >= n8) {
                                    int n14 = n45;
                                    int n15 = n210;
                                    int n16 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n16 >= 0) {
                                        int n17 = n14;
                                        DenseColumnDoubleMatrix2D.this.elements[n17] = DenseColumnDoubleMatrix2D.this.elements[n17] + dArray[n15];
                                        n14 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n15 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (d == -1.0) {
                                int n18 = n7;
                                while (--n18 >= n8) {
                                    int n19 = n45;
                                    int n20 = n210;
                                    int n21 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n21 >= 0) {
                                        int n22 = n19;
                                        DenseColumnDoubleMatrix2D.this.elements[n22] = DenseColumnDoubleMatrix2D.this.elements[n22] - dArray[n20];
                                        n19 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n20 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n23 = n7;
                                while (--n23 >= n8) {
                                    int n24 = n45;
                                    int n25 = n210;
                                    int n26 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n26 >= 0) {
                                        int n27 = n24;
                                        DenseColumnDoubleMatrix2D.this.elements[n27] = DenseColumnDoubleMatrix2D.this.elements[n27] + d * dArray[n25];
                                        n24 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n25 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
                            double d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
                            if (d == 1.0) {
                                int n28 = n7;
                                while (--n28 >= n8) {
                                    int n29 = n45;
                                    int n30 = n210;
                                    int n31 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n31 >= 0) {
                                        int n32 = n29;
                                        DenseColumnDoubleMatrix2D.this.elements[n32] = DenseColumnDoubleMatrix2D.this.elements[n32] + dArray[n30];
                                        n29 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n30 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (d == -1.0) {
                                int n33 = n7;
                                while (--n33 >= n8) {
                                    int n34 = n45;
                                    int n35 = n210;
                                    int n36 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n36 >= 0) {
                                        DenseColumnDoubleMatrix2D.this.elements[n34] = dArray[n35] - DenseColumnDoubleMatrix2D.this.elements[n34];
                                        n34 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n35 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n37 = n7;
                                while (--n37 >= n8) {
                                    int n38 = n45;
                                    int n39 = n210;
                                    int n40 = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--n40 >= 0) {
                                        DenseColumnDoubleMatrix2D.this.elements[n38] = d * DenseColumnDoubleMatrix2D.this.elements[n38] + dArray[n39];
                                        n38 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        n39 -= n4;
                                    }
                                    n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else {
                            int n41 = n7;
                            while (--n41 >= n8) {
                                int n42 = n45;
                                int n43 = n210;
                                int n44 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n44 >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[n42] = doubleDoubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n42], dArray[n43]);
                                    n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    n43 -= n4;
                                }
                                n45 -= DenseColumnDoubleMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n4 + (this.columns - 1) * n3;
            if (doubleDoubleFunction == DoubleFunctions.mult) {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n9;
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        int n15 = n12;
                        this.elements[n15] = this.elements[n15] * dArray[n13];
                        n12 -= this.rowStride;
                        n13 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (doubleDoubleFunction == DoubleFunctions.div) {
                int n16 = this.columns;
                while (--n16 >= 0) {
                    int n17 = n9;
                    int n18 = n10;
                    int n19 = this.rows;
                    while (--n19 >= 0) {
                        int n20 = n17;
                        this.elements[n20] = this.elements[n20] / dArray[n18];
                        n17 -= this.rowStride;
                        n18 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                double d2 = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                if (d2 == 1.0) {
                    int n21 = this.columns;
                    while (--n21 >= 0) {
                        int n22 = n9;
                        int n23 = n10;
                        int n24 = this.rows;
                        while (--n24 >= 0) {
                            int n25 = n22;
                            this.elements[n25] = this.elements[n25] + dArray[n23];
                            n22 -= this.rowStride;
                            n23 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (d2 == -1.0) {
                    int n26 = this.columns;
                    while (--n26 >= 0) {
                        int n27 = n9;
                        int n28 = n10;
                        int n29 = this.rows;
                        while (--n29 >= 0) {
                            int n30 = n27;
                            this.elements[n30] = this.elements[n30] - dArray[n28];
                            n27 -= this.rowStride;
                            n28 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n31 = this.columns;
                    while (--n31 >= 0) {
                        int n32 = n9;
                        int n33 = n10;
                        int n34 = this.rows;
                        while (--n34 >= 0) {
                            int n35 = n32;
                            this.elements[n35] = this.elements[n35] + d2 * dArray[n33];
                            n32 -= this.rowStride;
                            n33 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
                double d3 = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
                if (d3 == 1.0) {
                    int n36 = this.columns;
                    while (--n36 >= 0) {
                        int n37 = n9;
                        int n38 = n10;
                        int n39 = this.rows;
                        while (--n39 >= 0) {
                            int n40 = n37;
                            this.elements[n40] = this.elements[n40] + dArray[n38];
                            n37 -= this.rowStride;
                            n38 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (d3 == -1.0) {
                    int n41 = this.columns;
                    while (--n41 >= 0) {
                        int n42 = n9;
                        int n43 = n10;
                        int n44 = this.rows;
                        while (--n44 >= 0) {
                            this.elements[n42] = dArray[n43] - this.elements[n42];
                            n42 -= this.rowStride;
                            n43 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n45 = this.columns;
                    while (--n45 >= 0) {
                        int n46 = n9;
                        int n47 = n10;
                        int n48 = this.rows;
                        while (--n48 >= 0) {
                            this.elements[n46] = d3 * this.elements[n46] + dArray[n47];
                            n46 -= this.rowStride;
                            n47 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else {
                int n49 = this.columns;
                while (--n49 >= 0) {
                    int n50 = n9;
                    int n51 = n10;
                    int n52 = this.rows;
                    while (--n52 >= 0) {
                        this.elements[n50] = doubleDoubleFunction.apply(this.elements[n50], dArray[n51]);
                        n50 -= this.rowStride;
                        n51 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(doubleMatrix2D);
        if (!(doubleMatrix2D instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(doubleMatrix2D, doubleDoubleFunction);
            return this;
        }
        DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = (DenseColumnDoubleMatrix2D)doubleMatrix2D;
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final double[] dArray = denseColumnDoubleMatrix2D.elements();
        final int n2 = (int)denseColumnDoubleMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnDoubleMatrix2D.columnStride();
        final int n5 = denseColumnDoubleMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = n - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n8;
                        while (--n >= n9) {
                            int n22 = n3 + nArray[n] * DenseColumnDoubleMatrix2D.this.rowStride + nArray2[n] * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n32 = n2 + nArray[n] * n5 + nArray2[n] * n4;
                            DenseColumnDoubleMatrix2D.this.elements[n22] = doubleDoubleFunction.apply(DenseColumnDoubleMatrix2D.this.elements[n22], dArray[n32]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            while (--n10 >= 0) {
                int n11 = n3 + nArray[n10] * this.rowStride + nArray2[n10] * this.columnStride;
                int n12 = n2 + nArray[n10] * n5 + nArray2[n10] * n4;
                this.elements[n11] = doubleDoubleFunction.apply(this.elements[n11], dArray[n12]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] fArray) {
        if ((long)fArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = DenseColumnDoubleMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnDoubleMatrix2D.this.rows;
                        int n3 = n4;
                        while (--n3 >= n5) {
                            int n42 = n6;
                            int n52 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n52 >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[n42] = fArray[n2--];
                                n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = fArray.length - 1;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n6;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    this.elements[n9] = fArray[n7--];
                    n9 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n2 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n6 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n32 = n6;
                        while (--n32 >= n7) {
                            int n4 = n2;
                            int n5 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                if (DenseColumnDoubleMatrix2D.this.elements[n4] != 0.0) {
                                    ++n;
                                }
                                n4 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n2 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    if (this.elements[n10] != 0.0) {
                        ++n;
                    }
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    public void dct2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n5)).dct(bl);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2() {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward((double[])doubleMatrix2D.elements());
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n6)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.forward((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n5)).dst(bl);
            }
        }
    }

    public void dstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft2() {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward((double[])doubleMatrix2D.elements());
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                double d = DenseColumnDoubleMatrix2D.this.elements[n3];
                                if (d != 0.0) {
                                    DenseColumnDoubleMatrix2D.this.elements[n3] = intIntDoubleFunction.apply(n42, n2, d);
                                }
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    double d = this.elements[n8];
                    if (d != 0.0) {
                        this.elements[n8] = intIntDoubleFunction.apply(n9, n7, d);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DenseDoubleMatrix2D getRowMajor() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        final int n = (int)denseDoubleMatrix2D.index(0, 0);
        final int n2 = denseDoubleMatrix2D.rowStride();
        final int n3 = denseDoubleMatrix2D.columnStride();
        final double[] dArray = denseDoubleMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n4 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * n2 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                dArray[n5] = DenseColumnDoubleMatrix2D.this.elements[n42];
                                n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                n5 -= n2;
                            }
                            n9 -= DenseColumnDoubleMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n2 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    dArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n2;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return denseDoubleMatrix2D;
    }

    public DenseDComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] dArray = denseDComplexMatrix2D.elements();
        final int n2 = (int)this.index(0, 0);
        final int n3 = (int)denseDComplexMatrix2D.index(0, 0);
        final int n4 = denseDComplexMatrix2D.rowStride() / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * n4 + (n7 - 1) * 1;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n5 = n22;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                dArray[n5] = DenseColumnDoubleMatrix2D.this.elements[n42];
                                n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                n5 -= n4;
                            }
                            n -= DenseColumnDoubleMatrix2D.this.columnStride;
                            --n22;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n3 + (this.rows - 1) * n4 + (this.columns - 1) * 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    dArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n4;
                }
                n9 -= this.columnStride;
                --n10;
            }
        }
        this.fft2.realForwardFull(dArray);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getFftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseDComplexMatrix2D.viewColumn(n).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                denseDComplexMatrix2D.viewColumn(n6).assign(((DenseDoubleMatrix1D)this.viewColumn(n6)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getFftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseDComplexMatrix2D.viewRow(n).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.rows;
            while (--n6 >= 0) {
                denseDComplexMatrix2D.viewRow(n6).assign(((DenseDoubleMatrix1D)this.viewRow(n6)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] dArray = denseDComplexMatrix2D.elements();
        final int n2 = (int)this.index(0, 0);
        final int n3 = (int)denseDComplexMatrix2D.index(0, 0);
        final int n4 = denseDComplexMatrix2D.rowStride() / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * n4 + (n7 - 1) * 1;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n5 = n22;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                dArray[n5] = DenseColumnDoubleMatrix2D.this.elements[n42];
                                n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                n5 -= n4;
                            }
                            n -= DenseColumnDoubleMatrix2D.this.columnStride;
                            --n22;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n3 + (this.rows - 1) * n4 + (this.columns - 1) * 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    dArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n4;
                }
                n9 -= this.columnStride;
                --n10;
            }
        }
        this.fft2.realInverseFull(dArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DComplexMatrix2D getIfftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseDComplexMatrix2D.viewColumn(n).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                denseDComplexMatrix2D.viewColumn(n6).assign(((DenseDoubleMatrix1D)this.viewColumn(n6)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DComplexMatrix2D getIfftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseDComplexMatrix2D.viewRow(n).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.rows;
            while (--n6 >= 0) {
                denseDComplexMatrix2D.viewRow(n6).assign(((DenseDoubleMatrix1D)this.viewRow(n6)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                double d = this.elements[n2];
                if (d < 0.0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    doubleArrayList.add(d);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                double d = this.elements[n2];
                if (d != 0.0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    doubleArrayList.add(d);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                double d = this.elements[n2];
                if (d > 0.0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    doubleArrayList.add(d);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public double getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public void idct2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n5)).idct(bl);
            }
        }
    }

    public void idctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n6)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(n)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(n5)).idst(bl);
            }
        }
    }

    public void idstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(n)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft2(boolean bl) {
        DoubleMatrix2D doubleMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse((double[])doubleMatrix2D.elements(), bl);
        this.assign(doubleMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new DenseColumnDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public double[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double d = DenseColumnDoubleMatrix2D.this.elements[n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        int n = DenseColumnDoubleMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                double d2 = DenseColumnDoubleMatrix2D.this.elements[n6 * DenseColumnDoubleMatrix2D.this.rowStride + n5];
                                if (!(d < d2)) continue;
                                d = d2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d < dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    double d2 = this.elements[n12 * this.rowStride + n11];
                    if (!(d < d2)) continue;
                    d = d2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public double[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double d = DenseColumnDoubleMatrix2D.this.elements[n3 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        int n = DenseColumnDoubleMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n6 = DenseColumnDoubleMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                double d2 = DenseColumnDoubleMatrix2D.this.elements[n6 * DenseColumnDoubleMatrix2D.this.rowStride + n5];
                                if (!(d > d2)) continue;
                                d = d2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d > dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    double d2 = this.elements[n12 * this.rowStride + n11];
                    if (!(d > d2)) continue;
                    d = d2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = d;
    }

    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n4 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int n3 = n;
                            int n42 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                dArray[n42][n22] = DenseColumnDoubleMatrix2D.this.elements[n3];
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    dArray[n9][n7] = this.elements[n8];
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return dArray;
    }

    public DoubleMatrix1D vectorize() {
        int n = (int)this.size();
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((DoubleMatrix1D)denseDoubleMatrix1D).elements(), 0, n);
        } else {
            final int n2 = (int)this.index(0, 0);
            final int n3 = (int)((AbstractMatrix1D)denseDoubleMatrix1D).index(0);
            final int n4 = denseDoubleMatrix1D.stride();
            final double[] dArray = (double[])((DoubleMatrix1D)denseDoubleMatrix1D).elements();
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n5 = Math.min(n5, this.columns);
                Future[] futureArray = new Future[n5];
                int n6 = this.columns / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = this.columns - i * n6;
                    final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                    final int n9 = n - i * n6 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n7 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                            int n22 = n3 + (n9 - 1) * n4;
                            int n32 = n7;
                            while (--n32 >= n8) {
                                int n42 = n;
                                int n5 = DenseColumnDoubleMatrix2D.this.rows;
                                while (--n5 >= 0) {
                                    dArray[n22] = DenseColumnDoubleMatrix2D.this.elements[n42];
                                    n42 -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    n22 -= n4;
                                }
                                n -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n11 = n3 + n - 1;
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        dArray[n11] = this.elements[n13];
                        n13 -= this.rowStride;
                        --n11;
                    }
                    n10 -= this.columnStride;
                }
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2, boolean bl) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(bl ? this.columns : this.rows);
        }
        if ((long)(bl ? this.rows : this.columns) != doubleMatrix1D.size() || (long)(bl ? this.columns : this.rows) > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D) || this.isView() || doubleMatrix1D.isView() || doubleMatrix1D2.isView()) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        double[] dArray = (double[])doubleMatrix1D.elements();
        double[] dArray2 = (double[])doubleMatrix1D2.elements();
        Transpose transpose = bl ? Transpose.Transpose : Transpose.NoTranspose;
        BLAS.getInstance().dgemv(transpose.netlib(), this.rows, this.columns, d, this.elements, Math.max(this.rows, 1), dArray, 1, d2, dArray2, 1);
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        int n3 = bl2 ? doubleMatrix2D.columns() : doubleMatrix2D.rows();
        int n4 = bl2 ? doubleMatrix2D.rows() : doubleMatrix2D.columns();
        int n5 = n;
        int n6 = n4;
        if (n2 != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
        }
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseColumnDoubleMatrix2D(n5, n6);
        } else if (n != doubleMatrix2D2.rows() || n4 != doubleMatrix2D2.columns()) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(doubleMatrix2D instanceof DenseColumnDoubleMatrix2D) || !(doubleMatrix2D2 instanceof DenseColumnDoubleMatrix2D) || this.isView() || doubleMatrix2D.isView() || doubleMatrix2D2.isView()) {
            return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
        }
        Transpose transpose = bl ? Transpose.Transpose : Transpose.NoTranspose;
        Transpose transpose2 = bl2 ? Transpose.Transpose : Transpose.NoTranspose;
        double[] dArray = this.elements;
        double[] dArray2 = (double[])doubleMatrix2D.elements();
        double[] dArray3 = (double[])doubleMatrix2D2.elements();
        int n7 = bl ? Math.max(1, n2) : Math.max(1, n);
        int n8 = bl2 ? Math.max(1, n4) : Math.max(1, n3);
        int n9 = Math.max(1, n);
        BLAS.getInstance().dgemm(transpose.netlib(), transpose2.netlib(), n, n4, n2, d, dArray, n7, dArray2, n8, d2, dArray3, n9);
        return doubleMatrix2D2;
    }

    public double zSum() {
        double d = 0.0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n4 = this.columns / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = this.columns - n3 * n4;
                final int n6 = n3 == n2 - 1 ? 0 : n5 - n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        int n7 = n + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (n5 - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int n2 = n5;
                        while (--n2 >= n6) {
                            int n3 = n7;
                            int n4 = DenseColumnDoubleMatrix2D.this.rows;
                            while (--n4 >= 0) {
                                d += DenseColumnDoubleMatrix2D.this.elements[n3];
                                n3 -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            n7 -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                        return d;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    d += ((Double)futureArray[n3].get()).doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n7;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    d += this.elements[n9];
                    n9 -= this.rowStride;
                }
                n7 -= this.columnStride;
            }
        }
        return d;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedDenseColumnDoubleMatrix2D) {
            SelectedDenseColumnDoubleMatrix2D selectedDenseColumnDoubleMatrix2D = (SelectedDenseColumnDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedDenseColumnDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof DenseColumnDoubleMatrix2D) {
            DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = (DenseColumnDoubleMatrix2D)doubleMatrix2D;
            return this.elements == denseColumnDoubleMatrix2D.elements;
        }
        return false;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        return new DenseDoubleMatrix1D(n, this.elements, n2, n3, true);
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnDoubleMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

