/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tdouble;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleLongProcedure;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractDoubleLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractDoubleLongMap() {
    }

    public boolean containsKey(final double d) {
        return !this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d2) {
                return d != d2;
            }
        });
    }

    public boolean containsValue(final long l) {
        return !this.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double d, long l2) {
                return l != l2;
            }
        });
    }

    public AbstractDoubleLongMap copy() {
        return (AbstractDoubleLongMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractDoubleLongMap)) {
            return false;
        }
        final AbstractDoubleLongMap abstractDoubleLongMap = (AbstractDoubleLongMap)object;
        if (abstractDoubleLongMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double d, long l) {
                return abstractDoubleLongMap.containsKey(d) && abstractDoubleLongMap.get(d) == l;
            }
        }) && abstractDoubleLongMap.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double d, long l) {
                return AbstractDoubleLongMap.this.containsKey(d) && AbstractDoubleLongMap.this.get(d) == l;
            }
        });
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleLongProcedure doubleLongProcedure) {
        return this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                return doubleLongProcedure.apply(d, AbstractDoubleLongMap.this.get(d));
            }
        });
    }

    public abstract long get(double var1);

    public double keyOf(final long l) {
        final double[] dArray = new double[1];
        boolean bl = this.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double d, long l2) {
                boolean bl;
                boolean bl2 = bl = l == l2;
                if (bl) {
                    dArray[0] = d;
                }
                return !bl;
            }
        });
        if (bl) {
            return Double.NaN;
        }
        return dArray[0];
    }

    public DoubleArrayList keys() {
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.size());
        this.keys(doubleArrayList);
        return doubleArrayList;
    }

    public void keys(final DoubleArrayList doubleArrayList) {
        doubleArrayList.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                doubleArrayList.add(d);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList doubleArrayList) {
        this.pairsSortedByValue(doubleArrayList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final DoubleLongProcedure doubleLongProcedure, final DoubleArrayList doubleArrayList, final LongArrayList longArrayList) {
        doubleArrayList.clear();
        longArrayList.clear();
        this.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double d, long l) {
                if (doubleLongProcedure.apply(d, l)) {
                    doubleArrayList.add(d);
                    longArrayList.add(l);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList doubleArrayList, LongArrayList longArrayList) {
        this.keys(doubleArrayList);
        doubleArrayList.sort();
        longArrayList.setSize(doubleArrayList.size());
        int n = doubleArrayList.size();
        while (--n >= 0) {
            longArrayList.setQuick(n, this.get(doubleArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList doubleArrayList, LongArrayList longArrayList) {
        this.keys(doubleArrayList);
        this.values(longArrayList);
        final double[] dArray = doubleArrayList.elements();
        final long[] lArray = longArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return lArray[n] < lArray[n2] ? -1 : (lArray[n] > lArray[n2] ? 1 : (dArray[n] < dArray[n2] ? -1 : (dArray[n] == dArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, doubleArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(double var1, long var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList doubleArrayList = this.keys();
        doubleArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = doubleArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            double d = doubleArrayList.get(i);
            stringBuffer.append(String.valueOf(d));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(d)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.keysSortedByValue(doubleArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = doubleArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            double d = doubleArrayList.get(i);
            stringBuffer.append(String.valueOf(d));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(d)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public LongArrayList values() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.values(longArrayList);
        return longArrayList;
    }

    public void values(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                longArrayList.add(AbstractDoubleLongMap.this.get(d));
                return true;
            }
        });
    }
}

